/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.server.editors;

import java.util.Collection;
import java.util.HashMap;
import net.inveed.gwt.editor.shared.forms.panels.AutoFormViewDTO;
import net.inveed.gwt.server.annotations.editor.UIAutoEditorView;
import net.inveed.gwt.server.annotations.editor.UIEditorField;
import net.inveed.gwt.server.editors.AutoFormBuilder;
import net.inveed.gwt.server.editors.AutoFormRootPanelBuilder;
import net.inveed.gwt.server.editors.FieldInView;

public class AutoFormViewBuilder {
    public final String name;
    public final UIAutoEditorView viewAnnotation;
    private AutoFormViewBuilder parent;

    public AutoFormViewBuilder(UIAutoEditorView viewAnnotation) {
        this.name = viewAnnotation.viewName();
        this.viewAnnotation = viewAnnotation;
    }

    public AutoFormViewBuilder(String viewName) {
        this.name = viewName;
        this.viewAnnotation = null;
    }

    public void setParent(AutoFormViewBuilder parent) {
        this.parent = parent;
    }

    public AutoFormViewBuilder getParent() {
        return this.parent;
    }

    public AutoFormViewDTO build(Collection<AutoFormBuilder.Field> fields, AutoFormRootPanelBuilder root) {
        HashMap<String, FieldInView> fldInViews = new HashMap<String, FieldInView>();
        for (AutoFormBuilder.Field fld : fields) {
            UIEditorField fa = this.findFieldAnnotation(fld);
            if (fa == null) continue;
            AutoFormRootPanelBuilder section = root.getSection(fa.container());
            if (section == null) {
                section = root;
            }
            FieldInView fldInView = new FieldInView(fld.name, fld.builder, fld.property, fa, section);
            fldInViews.put(fld.name, fldInView);
        }
        return root.buildRow(this.name, this.getWidth(), this.getHeight(), fldInViews);
    }

    private Integer getWidth() {
        Integer ret;
        Integer n = this.viewAnnotation == null ? null : (ret = this.viewAnnotation.width() == 0 ? null : Integer.valueOf(this.viewAnnotation.width()));
        if (ret == null && this.getParent() != null) {
            return this.getParent().getWidth();
        }
        return ret;
    }

    private Integer getHeight() {
        Integer ret;
        Integer n = this.viewAnnotation == null ? null : (ret = this.viewAnnotation.heigh() == 0 ? null : Integer.valueOf(this.viewAnnotation.heigh()));
        if (ret == null && this.getParent() != null) {
            return this.getParent().getHeight();
        }
        return ret;
    }

    private UIEditorField findFieldAnnotation(AutoFormBuilder.Field f) {
        UIEditorField ret = f.annotations.get(this.name);
        if (ret != null) {
            return ret;
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().findFieldAnnotation(f);
    }
}

