/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.server.editors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import net.inveed.commons.reflection.BeanPropertyDesc;
import net.inveed.commons.reflection.BeanTypeDesc;
import net.inveed.gwt.editor.shared.forms.panels.AutoFormViewDTO;
import net.inveed.gwt.server.EntityModelBuilder;
import net.inveed.gwt.server.annotations.editor.UIAutoEditorView;
import net.inveed.gwt.server.annotations.editor.UIAutoEditorViews;
import net.inveed.gwt.server.annotations.editor.UIEditorField;
import net.inveed.gwt.server.annotations.editor.UIEditorSection;
import net.inveed.gwt.server.annotations.editor.UIEditorSections;
import net.inveed.gwt.server.annotations.editor.UIEditorTabPanel;
import net.inveed.gwt.server.annotations.editor.UIEditorTabPanels;
import net.inveed.gwt.server.annotations.editor.UIEditorsField;
import net.inveed.gwt.server.editors.AbstractPanelBuilder;
import net.inveed.gwt.server.editors.AutoFormRootPanelBuilder;
import net.inveed.gwt.server.editors.AutoFormSectionPanelBuilder;
import net.inveed.gwt.server.editors.AutoFormTabPanelBuilder;
import net.inveed.gwt.server.editors.AutoFormViewBuilder;
import net.inveed.gwt.server.propbuilders.IPropertyBuiler;

public class AutoFormBuilder {
    private BeanTypeDesc<?> bean;
    private HashMap<String, UIAutoEditorView> declaredViews;
    private AutoFormRootPanelBuilder rootBuilder;

    public AutoFormBuilder(BeanTypeDesc<?> bean) {
        this.bean = bean;
    }

    public HashMap<String, AutoFormViewDTO> build(EntityModelBuilder modelBuilder) {
        this.parse();
        ArrayList<String> foundViews = new ArrayList<String>();
        HashMap<String, Field> fields = this.findAllFields(modelBuilder, foundViews);
        HashMap<String, AutoFormViewDTO> ret = new HashMap<String, AutoFormViewDTO>();
        HashMap<String, AutoFormViewBuilder> builders = new HashMap<String, AutoFormViewBuilder>();
        for (String v : this.declaredViews.keySet()) {
            UIAutoEditorView viewAnnotation = this.declaredViews.get(v);
            builders.put(viewAnnotation.viewName(), new AutoFormViewBuilder(viewAnnotation));
        }
        for (String v : foundViews) {
            if (builders.containsKey(v = v.trim())) continue;
            builders.put(v, new AutoFormViewBuilder(v));
        }
        AutoFormViewBuilder rootBuilder = (AutoFormViewBuilder)builders.get("");
        for (AutoFormViewBuilder bldr : builders.values()) {
            if (bldr.name.equals("")) continue;
            if (bldr.viewAnnotation == null) {
                bldr.setParent(rootBuilder);
                continue;
            }
            AutoFormViewBuilder pb = (AutoFormViewBuilder)builders.get(bldr.viewAnnotation.inheritFrom());
            if (pb == null) {
                pb = rootBuilder;
            }
            bldr.setParent(pb);
        }
        for (AutoFormViewBuilder vb : builders.values()) {
            AutoFormViewDTO dto = vb.build(fields.values(), this.rootBuilder);
            if (dto == null) continue;
            ret.put(vb.name, dto);
        }
        return ret;
    }

    HashMap<String, Field> findAllFields(EntityModelBuilder modelBuilder, ArrayList<String> foundViews) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        HashMap<String, Boolean> fvmap = new HashMap<String, Boolean>();
        for (BeanPropertyDesc prop : this.bean.getProperties()) {
            HashMap<String, UIEditorField> annotations = AutoFormBuilder.getFieldAnnotations(prop);
            if (annotations == null || annotations.size() == 0) continue;
            for (String fv : annotations.keySet()) {
                fvmap.put(fv, true);
            }
            IPropertyBuiler<?> builder = EntityModelBuilder.getBuilder(prop);
            if (builder == null) continue;
            builder.prepare(prop);
            String name = builder.getPropertyName();
            Field fld = new Field(name, builder, prop, annotations);
            fields.put(name, fld);
        }
        foundViews.addAll(fvmap.keySet());
        return fields;
    }

    private static HashMap<String, UIEditorField> getFieldAnnotations(BeanPropertyDesc prop) {
        UIEditorsField flds;
        HashMap<String, UIEditorField> ret = new HashMap<String, UIEditorField>();
        UIEditorField fld = (UIEditorField)prop.getAnnotation(UIEditorField.class);
        if (fld != null) {
            if (fld.forViews().length > 0) {
                for (String fv : fld.forViews()) {
                    if (ret.containsKey(fv)) continue;
                    ret.put(fv, fld);
                }
            } else if (!ret.containsKey(fld.forView())) {
                ret.put(fld.forView(), fld);
            }
        }
        if ((flds = (UIEditorsField)prop.getAnnotation(UIEditorsField.class)) != null) {
            for (UIEditorField fld1 : flds.value()) {
                if (fld1.forViews().length > 0) {
                    for (String fv : fld1.forViews()) {
                        if (ret.containsKey(fv)) continue;
                        ret.put(fv, fld1);
                    }
                    continue;
                }
                if (ret.containsKey(fld1.forView())) continue;
                ret.put(fld1.forView(), fld1);
            }
        }
        return ret;
    }

    public void parse() {
        this.declaredViews = new HashMap();
        AutoFormBuilder.parseViews(this.bean, this.declaredViews);
        if (!this.declaredViews.containsKey("")) {
            UIAutoEditorView allViewsAnnotation = new UIAutoEditorView(){

                public Class<? extends Annotation> annotationType() {
                    return UIAutoEditorView.class;
                }

                public int width() {
                    return 0;
                }

                public String viewName() {
                    return "";
                }

                public int heigh() {
                    return 0;
                }

                public String inheritFrom() {
                    return "";
                }
            };
            this.declaredViews.put("", allViewsAnnotation);
        }
        HashMap declaredSections = new HashMap();
        AutoFormBuilder.parseSections(this.bean, declaredSections);
        for (BeanPropertyDesc beanPropertyDesc : this.bean.getProperties()) {
            AutoFormBuilder.parseSections(beanPropertyDesc, declaredSections);
        }
        for (AbstractPanelBuilder abstractPanelBuilder : declaredSections.values()) {
            if (!(abstractPanelBuilder instanceof AutoFormTabPanelBuilder)) continue;
            AutoFormBuilder.findNativeChildren((AutoFormTabPanelBuilder)abstractPanelBuilder);
        }
        for (AbstractPanelBuilder abstractPanelBuilder : declaredSections.values()) {
            AbstractPanelBuilder<?> parent;
            String string;
            if (abstractPanelBuilder.parentName == null || (string = abstractPanelBuilder.parentName.trim()).length() <= 0 || (parent = declaredSections.get(string)) == null) continue;
            parent.children.add(abstractPanelBuilder);
            abstractPanelBuilder.parent = parent;
        }
        ArrayList rootLeafs = new ArrayList();
        for (AbstractPanelBuilder<?> abstractPanelBuilder : declaredSections.values()) {
            abstractPanelBuilder.children.sort(new Comparator<AbstractPanelBuilder<?>>(){

                @Override
                public int compare(AbstractPanelBuilder<?> o1, AbstractPanelBuilder<?> o2) {
                    int ret = Integer.compare(o1.order, o2.order);
                    if (ret != 0) {
                        return ret;
                    }
                    return o1.name.compareTo(o2.name);
                }
            });
            if (abstractPanelBuilder.parent != null) continue;
            rootLeafs.add(abstractPanelBuilder);
        }
        AutoFormRootPanelBuilder autoFormRootPanelBuilder = new AutoFormRootPanelBuilder("", null, null, 0);
        if (rootLeafs.size() > 0) {
            for (AbstractPanelBuilder rl : rootLeafs) {
                autoFormRootPanelBuilder.children.add(rl);
                rl.parent = autoFormRootPanelBuilder;
            }
        }
        this.rootBuilder = autoFormRootPanelBuilder;
    }

    private static void parseViews(BeanTypeDesc<?> bean, HashMap<String, UIAutoEditorView> declaredViews) {
        UIAutoEditorViews vs;
        UIAutoEditorView v1 = (UIAutoEditorView)bean.getAnnotation(UIAutoEditorView.class);
        if (v1 != null && !declaredViews.containsKey(v1.viewName())) {
            declaredViews.put(v1.viewName(), v1);
        }
        if ((vs = (UIAutoEditorViews)bean.getAnnotation(UIAutoEditorViews.class)) != null) {
            for (UIAutoEditorView v : vs.value()) {
                if (declaredViews.containsKey(v.viewName())) continue;
                declaredViews.put(v.viewName(), v);
            }
        }
        if (bean.getSupertype() != null && bean.getSupertype().getType() != Object.class) {
            AutoFormBuilder.parseViews(bean.getSupertype(), declaredViews);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseSections(BeanPropertyDesc property, HashMap<String, AbstractPanelBuilder<?>> result) {
        UIEditorTabPanel ta;
        UIEditorSection sa;
        UIEditorSections sas = (UIEditorSections)property.getAnnotation(UIEditorSections.class);
        if (sas != null) {
            for (UIEditorSection e : sas.value()) {
                if (result.containsKey(e.name())) {
                    AbstractPanelBuilder<?> a = result.get(e.name());
                    if (a.annotation.annotationType() != UIEditorSection.class) continue;
                    continue;
                }
                result.put(e.name(), new AutoFormSectionPanelBuilder(e.name(), e.parent(), e, e.order()));
            }
        }
        if ((sa = (UIEditorSection)property.getAnnotation(UIEditorSection.class)) != null) {
            if (result.containsKey(sa.name())) {
                AbstractPanelBuilder<?> a = result.get(sa.name());
                if (a.annotation.annotationType() == UIEditorSection.class) {
                    // empty if block
                }
            } else {
                result.put(sa.name(), new AutoFormSectionPanelBuilder(sa.name(), sa.parent(), sa, sa.order()));
            }
        }
        UIEditorTabPanels tas = (UIEditorTabPanels)property.getAnnotation(UIEditorTabPanels.class);
        if (sas != null) {
            for (UIEditorTabPanel e : tas.value()) {
                if (result.containsKey(e.id())) {
                    AbstractPanelBuilder<?> a = result.get(e.id());
                    if (a.annotation.annotationType() != UIEditorTabPanel.class) continue;
                    continue;
                }
                result.put(e.id(), new AutoFormTabPanelBuilder(e.id(), e.parent(), e, e.order()));
            }
        }
        if ((ta = (UIEditorTabPanel)property.getAnnotation(UIEditorTabPanel.class)) == null) return;
        if (result.containsKey(ta.id())) {
            AbstractPanelBuilder<?> a = result.get(ta.id());
            if (a.annotation.annotationType() == UIEditorTabPanel.class) return;
            return;
        } else {
            result.put(ta.id(), new AutoFormTabPanelBuilder(ta.id(), ta.parent(), ta, ta.order()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseSections(BeanTypeDesc<?> bean, HashMap<String, AbstractPanelBuilder<?>> result) {
        UIEditorTabPanel ta;
        UIEditorSection sa;
        UIEditorSections sas = (UIEditorSections)bean.getAnnotation(UIEditorSections.class);
        if (sas != null) {
            for (UIEditorSection e : sas.value()) {
                if (result.containsKey(e.name())) {
                    AbstractPanelBuilder<?> a = result.get(e.name());
                    if (a.annotation.annotationType() != UIEditorSection.class) continue;
                    continue;
                }
                result.put(e.name(), new AutoFormSectionPanelBuilder(e.name(), e.parent(), e, e.order()));
            }
        }
        if ((sa = (UIEditorSection)bean.getAnnotation(UIEditorSection.class)) != null) {
            if (result.containsKey(sa.name())) {
                AbstractPanelBuilder<?> a = result.get(sa.name());
                if (a.annotation.annotationType() == UIEditorSection.class) {
                    // empty if block
                }
            } else {
                result.put(sa.name(), new AutoFormSectionPanelBuilder(sa.name(), sa.parent(), sa, sa.order()));
            }
        }
        UIEditorTabPanels tas = (UIEditorTabPanels)bean.getAnnotation(UIEditorTabPanels.class);
        if (sas != null) {
            for (UIEditorTabPanel e : tas.value()) {
                if (result.containsKey(e.id())) {
                    AbstractPanelBuilder<?> a = result.get(e.id());
                    if (a.annotation.annotationType() != UIEditorTabPanel.class) continue;
                    continue;
                }
                result.put(e.id(), new AutoFormTabPanelBuilder(e.id(), e.parent(), e, e.order()));
            }
        }
        if ((ta = (UIEditorTabPanel)bean.getAnnotation(UIEditorTabPanel.class)) != null) {
            if (result.containsKey(ta.id())) {
                AbstractPanelBuilder<?> a = result.get(ta.id());
                if (a.annotation.annotationType() == UIEditorTabPanel.class) {
                    // empty if block
                }
            } else {
                result.put(ta.id(), new AutoFormTabPanelBuilder(ta.id(), ta.parent(), ta, ta.order()));
            }
        }
        if (bean.getSupertype() != null && bean.getSupertype().getType() != Object.class) {
            AutoFormBuilder.parseSections(bean.getSupertype(), result);
        }
    }

    private static void findNativeChildren(AutoFormTabPanelBuilder leaf) {
        int o = 1;
        for (UIEditorSection section : ((UIEditorTabPanel)leaf.annotation).tabs()) {
            AutoFormSectionPanelBuilder sl = new AutoFormSectionPanelBuilder(section.name(), leaf.name, section, section.order() == 0 ? o : section.order());
            leaf.children.add(sl);
            sl.parent = leaf;
            ++o;
        }
    }

    public static final class Field {
        public final String name;
        public final IPropertyBuiler<?> builder;
        public final BeanPropertyDesc property;
        public final HashMap<String, UIEditorField> annotations;

        public Field(String name, IPropertyBuiler<?> builder, BeanPropertyDesc prop, HashMap<String, UIEditorField> annotations) {
            this.name = name;
            this.builder = builder;
            this.property = prop;
            this.annotations = annotations;
        }
    }
}

