/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.server.editors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.inveed.gwt.editor.commons.FormFieldLocation;
import net.inveed.gwt.editor.shared.forms.EditorFieldDTO;
import net.inveed.gwt.editor.shared.forms.panels.EditorSectionDTO;
import net.inveed.gwt.editor.shared.forms.rows.EditorFieldsRowDTO;
import net.inveed.gwt.editor.shared.forms.rows.EditorListRowDTO;
import net.inveed.gwt.editor.shared.forms.rows.IEditorRowDTO;
import net.inveed.gwt.server.editors.AutoFormSectionPanelBuilder;
import net.inveed.gwt.server.editors.FieldInView;
import net.inveed.gwt.server.propbuilders.EntityListPropertyBuilder;

public abstract class AbstractPanelBuilder<T extends Annotation> {
    public final String name;
    public final String parentName;
    public final T annotation;
    public final int order;
    public final List<AbstractPanelBuilder<?>> children;
    public AbstractPanelBuilder<?> parent;

    public abstract AbstractPanelBuilder<?> getSection(String var1);

    public AbstractPanelBuilder(String name, String parent, T annotation, int order) {
        this.name = name;
        this.parentName = parent;
        this.annotation = annotation;
        this.parent = null;
        this.order = order;
        this.children = new ArrayList();
    }

    protected IEditorRowDTO[] buildRows(String viewName, Map<String, FieldInView> fields) {
        AbstractPanelBuilder<?> child;
        ArrayList<FieldInView> myFields = new ArrayList<FieldInView>();
        for (FieldInView f : fields.values()) {
            if (f.container != this) continue;
            myFields.add(f);
        }
        if (myFields.size() == 0 && this.children.size() == 0) {
            return null;
        }
        ArrayList<Object> globalRows = new ArrayList<Object>();
        if (myFields.size() > 0) {
            IEditorRowDTO[] fieldRows = this.getFieldRows(myFields);
            if (this.children.size() == 0) {
                return fieldRows;
            }
            EditorSectionDTO fakeSection = new EditorSectionDTO(fieldRows, null);
            globalRows.add(fakeSection);
        }
        if (this.children.size() == 0 && globalRows.size() == 0 && (child = this.children.get(0)) instanceof AutoFormSectionPanelBuilder) {
            return child.buildRows(viewName, fields);
        }
        for (AbstractPanelBuilder<?> child2 : this.children) {
            IEditorRowDTO row = child2.buildRow(viewName, fields);
            globalRows.add(row);
        }
        if (globalRows.size() == 0) {
            return null;
        }
        return globalRows.toArray(new IEditorRowDTO[0]);
    }

    private IEditorRowDTO[] getFieldRows(ArrayList<FieldInView> fields) {
        fields.sort(new Comparator<FieldInView>(){

            @Override
            public int compare(FieldInView o1, FieldInView o2) {
                int ret = Integer.compare(o1.annotation.order(), o2.annotation.order());
                if (ret != 0) {
                    return ret;
                }
                if (o1.annotation.location() == FormFieldLocation.LEFT) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<Object> rows = new ArrayList<Object>();
        EditorFieldDTO pendingField = null;
        for (FieldInView f : fields) {
            EditorFieldsRowDTO rdto;
            EditorFieldDTO fld;
            EditorListRowDTO rdto2;
            if (f.builder instanceof EntityListPropertyBuilder) {
                rdto2 = new EditorListRowDTO(f.builder.getPropertyName());
                rows.add(rdto2);
                continue;
            }
            if (f.annotation.location() == FormFieldLocation.BOTH) {
                if (pendingField != null) {
                    rdto2 = new EditorFieldsRowDTO(new EditorFieldDTO[]{pendingField});
                    rows.add(rdto2);
                    pendingField = null;
                }
                fld = AbstractPanelBuilder.getFieldDTO(f);
                rdto = new EditorFieldsRowDTO(new EditorFieldDTO[]{fld});
                rows.add(rdto);
                continue;
            }
            if (f.annotation.location() == FormFieldLocation.LEFT) {
                if (pendingField != null) {
                    rdto2 = new EditorFieldsRowDTO(new EditorFieldDTO[]{pendingField});
                    rows.add(rdto2);
                }
                pendingField = AbstractPanelBuilder.getFieldDTO(f);
                continue;
            }
            if (f.annotation.location() != FormFieldLocation.RIGHT) continue;
            fld = AbstractPanelBuilder.getFieldDTO(f);
            if (pendingField != null) {
                rdto = new EditorFieldsRowDTO(new EditorFieldDTO[]{pendingField, fld});
                rows.add(rdto);
                pendingField = null;
                continue;
            }
            rdto = new EditorFieldsRowDTO(new EditorFieldDTO[]{fld});
            rows.add(rdto);
        }
        if (pendingField != null) {
            EditorFieldsRowDTO rdto = new EditorFieldsRowDTO(new EditorFieldDTO[]{pendingField});
            rows.add(rdto);
        }
        return rows.toArray(new IEditorRowDTO[0]);
    }

    private static final EditorFieldDTO getFieldDTO(FieldInView af) {
        return new EditorFieldDTO(af.name, null, af.annotation.readonly());
    }

    protected abstract IEditorRowDTO buildRow(String var1, Map<String, FieldInView> var2);
}

