/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.server.auth;

import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.Base64;
import net.inveed.commons.NumberedException;
import net.inveed.commons.utils.ByteArrayConvertor;
import net.inveed.commons.utils.CryptoUtil;
import net.inveed.gwt.editor.shared.auth.AuthorizationResponse;
import net.inveed.gwt.server.auth.ICredentialProvider;
import net.inveed.gwt.server.auth.IUserCredential;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class SecurityProvider {
    private final ICredentialProvider credentialProvider;
    private final RSAPrivateKey pkey;

    public SecurityProvider(ICredentialProvider cp, RSAPrivateKey pkey) {
        this.credentialProvider = cp;
        this.pkey = pkey;
    }

    public AuthorizationResponse authorize(String username, String pwd, String sk, String time) throws NumberedException, InvalidCipherTextException {
        long diff;
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (pwd == null) {
            throw new NullPointerException("pwdHash");
        }
        if (sk == null) {
            throw new NullPointerException("rnd");
        }
        if (time == null) {
            throw new NullPointerException("rnd");
        }
        if ((username = username.trim().toLowerCase()).length() == 0) {
            throw new NullPointerException("username");
        }
        byte[] skEncrypted = Base64.getDecoder().decode(sk);
        byte[] pwdEncrypted = Base64.getDecoder().decode(pwd);
        byte[] timeEncrypted = Base64.getDecoder().decode(time);
        RSAKeyParameters privateKey = new RSAKeyParameters(true, this.pkey.getModulus(), this.pkey.getPrivateExponent());
        PKCS1Encoding eng = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        eng.init(false, (CipherParameters)privateKey);
        byte[] skClear = eng.processBlock(skEncrypted, 0, skEncrypted.length);
        byte[] aesKey = Arrays.copyOfRange(skClear, 0, 16);
        byte[] aesIV = Arrays.copyOfRange(skClear, 16, 32);
        byte[] pwdClear = CryptoUtil.decryptAESCBC_PKCS7Padding((byte[])pwdEncrypted, (byte[])aesKey, (byte[])aesIV);
        byte[] timeClear = CryptoUtil.decryptAESCBC_PKCS7Padding((byte[])timeEncrypted, (byte[])aesKey, (byte[])aesIV);
        long timeMills = ByteArrayConvertor.byteArrayToLong((byte[])timeClear);
        long currentTimeSeconds = System.currentTimeMillis();
        long l = diff = currentTimeSeconds > timeMills ? currentTimeSeconds - timeMills : timeMills - currentTimeSeconds;
        if (diff > 120000L) {
            return new AuthorizationResponse(-20);
        }
        IUserCredential u = this.credentialProvider.getUserCredential(username, new String(pwdClear));
        if (u == null) {
            return new AuthorizationResponse(-1);
        }
        return u.authorize();
    }
}

