/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import net.inveed.commons.reflection.BeanPropertyDesc;
import net.inveed.commons.reflection.BeanTypeDesc;
import net.inveed.commons.reflection.EnumTypeDesc;
import net.inveed.commons.reflection.JavaTypeDesc;
import net.inveed.commons.reflection.JavaTypeRegistry;
import net.inveed.commons.reflection.ListTypeDesc;
import net.inveed.commons.reflection.NativeTypeDesc;
import net.inveed.gwt.editor.shared.FieldType;
import net.inveed.gwt.editor.shared.FormViewAttributesDTO;
import net.inveed.gwt.editor.shared.ListViewAttributesDTO;
import net.inveed.gwt.editor.shared.PropertyModelDTO;
import net.inveed.gwt.server.FormViewAttributesBuilder;
import net.inveed.gwt.server.ListViewAttributesBuilder;
import net.inveed.gwt.server.PropertyAttributesBuilder;
import net.inveed.gwt.server.annotations.UIAsName;
import net.inveed.gwt.server.annotations.UIFormView;
import net.inveed.gwt.server.annotations.UIFormViews;
import net.inveed.gwt.server.annotations.UIListView;
import net.inveed.gwt.server.annotations.UIListViews;
import net.inveed.gwt.server.annotations.UIProperty;
import net.inveed.gwt.server.annotations.UIRangeValidator;
import net.inveed.gwt.server.annotations.UISelectionFilter;
import net.inveed.gwt.server.annotations.UISelectionFilters;
import net.inveed.gwt.server.annotations.UITextFieldValidator;
import net.inveed.rest.jpa.IComplexIdEntity;
import net.inveed.rest.jpa.IEntityInstantiator;
import net.inveed.rest.jpa.annotations.EntityInstantiator;
import net.inveed.rest.jpa.typeutils.EntityTypeExt;
import net.inveed.rest.jpa.typeutils.JsonPropertyExt;

public class PropertyModelBuilder {
    private transient BeanPropertyDesc desc;
    public FieldType type;
    public String defaultValue;
    public String enabledWhen;
    public PropertyAttributesBuilder attributes = new PropertyAttributesBuilder();
    public Map<String, FormViewAttributesDTO> formViews = new HashMap<String, FormViewAttributesDTO>();
    public Map<String, ListViewAttributesDTO> listViews = new HashMap<String, ListViewAttributesDTO>();
    public Map<String, String> filters = new HashMap<String, String>();
    public String name;

    public PropertyModelDTO build() {
        if (this.type == null) {
            return null;
        }
        return new PropertyModelDTO(this.type, this.defaultValue, this.enabledWhen, this.attributes.build(), this.formViews.size() != 0 ? this.formViews : null, this.listViews.size() != 0 ? this.listViews : null, this.filters.size() != 0 ? this.filters : null);
    }

    private void parse() {
        UIFormViews fvsa;
        UIListViews lvsa;
        UIFormView fva;
        this.type = this.findType();
        if (this.type == null) {
            return;
        }
        this._setProperties();
        JsonPropertyExt jpe = (JsonPropertyExt)this.desc.getExtension(JsonPropertyExt.class);
        this.name = jpe != null ? jpe.getJSONName() : this.desc.getName();
        UIAsName ana = (UIAsName)this.desc.getAnnotation(UIAsName.class);
        if (ana != null) {
            this.attributes.asNameIndex = ana.value();
        }
        ArrayList<UIListView> listViews = new ArrayList<UIListView>();
        ArrayList<UIFormView> formViews = new ArrayList<UIFormView>();
        UIListView lva = (UIListView)this.desc.getAnnotation(UIListView.class);
        if (lva != null) {
            listViews.add(lva);
        }
        if ((fva = (UIFormView)this.desc.getAnnotation(UIFormView.class)) != null) {
            formViews.add(fva);
        }
        if ((lvsa = (UIListViews)this.desc.getAnnotation(UIListViews.class)) != null) {
            Collections.addAll(listViews, lvsa.value());
        }
        if ((fvsa = (UIFormViews)this.desc.getAnnotation(UIFormViews.class)) != null) {
            Collections.addAll(formViews, fvsa.value());
        }
        for (UIFormView uIFormView : formViews) {
            this.formViews.put(uIFormView.name(), new FormViewAttributesBuilder(uIFormView).build());
        }
        for (UIListView uIListView : listViews) {
            this.listViews.put(uIListView.name(), new ListViewAttributesBuilder(uIListView).build());
        }
        UIProperty fa = (UIProperty)this.desc.getAnnotation(UIProperty.class);
        if (fa != null) {
            this.defaultValue = fa.defaultValue().length() != 0 ? fa.defaultValue() : null;
            this.enabledWhen = fa.enabledWhen().length() != 0 ? fa.enabledWhen() : null;
        }
    }

    @JsonIgnore(value=true)
    private void _setProperties() {
        UIRangeValidator rangeValidator = (UIRangeValidator)this.desc.getAnnotation(UIRangeValidator.class);
        UITextFieldValidator tfv = (UITextFieldValidator)this.desc.getAnnotation(UITextFieldValidator.class);
        if (this._isReadonly()) {
            this.attributes.readonly = true;
        }
        this.attributes.required = this._isRequired();
        switch (this.type) {
            case OBJECT_REF: {
                JavaTypeDesc tdef = this.desc.getType();
                if (tdef instanceof BeanTypeDesc) {
                    this.setRefTypeProperty((BeanTypeDesc)tdef);
                }
                UISelectionFilter[] filters = null;
                UISelectionFilters aFilters = (UISelectionFilters)this.desc.getAnnotation(UISelectionFilters.class);
                if (aFilters != null) {
                    filters = aFilters.value();
                } else {
                    UISelectionFilter aFilter = (UISelectionFilter)this.desc.getAnnotation(UISelectionFilter.class);
                    if (aFilter != null) {
                        filters = new UISelectionFilter[]{aFilter};
                    }
                }
                if (filters != null) {
                    for (UISelectionFilter f : filters) {
                        this.filters.put(f.param(), f.value());
                    }
                }
            }
            case INTEGER: 
            case FLOAT: 
            case DURATION_ISO: 
            case DURATION_MIN: 
            case DURATION_SECONDS: 
            case DURATION_MS: {
                if (rangeValidator == null) break;
                if (rangeValidator.max() != Double.MIN_VALUE) {
                    this.attributes.max = rangeValidator.max();
                }
                if (rangeValidator.min() == Double.MAX_VALUE) break;
                this.attributes.min = rangeValidator.min();
                break;
            }
            case SECRET_KEY: 
            case BINARY_KEY: {
                if (rangeValidator != null && rangeValidator.min() != Double.MAX_VALUE) {
                    this.attributes.min = rangeValidator.min();
                }
            }
            case TEXT: 
            case TEXT_LONG: 
            case URL: {
                if (rangeValidator != null) {
                    this.attributes.max = rangeValidator.max() != Double.MIN_VALUE ? Double.valueOf(rangeValidator.max()) : this._getLengthFromAnnotation();
                    if (rangeValidator.min() != Double.MAX_VALUE) {
                        this.attributes.min = rangeValidator.min();
                    }
                } else {
                    this.attributes.max = this._getLengthFromAnnotation();
                }
                if (tfv == null) break;
                if (tfv.regexp().trim().length() > 0 && this.type != FieldType.URL) {
                    this.attributes.regexp = tfv.regexp().trim();
                }
                if (tfv.regexpError().trim().length() > 0) {
                    this.attributes.regexpError = tfv.regexpError().trim();
                    break;
                }
                if (tfv.startWith().length() <= 0) break;
                this.attributes.startWith = tfv.startWith();
                break;
            }
            case ADDR_HOST: 
            case PASSWORD: {
                if (rangeValidator != null) {
                    this.attributes.max = rangeValidator.max() != Double.MIN_VALUE ? Double.valueOf(rangeValidator.max()) : this._getLengthFromAnnotation();
                    if (rangeValidator.min() == Double.MAX_VALUE) break;
                    this.attributes.min = rangeValidator.min();
                    break;
                }
                this.attributes.max = this._getLengthFromAnnotation();
                break;
            }
            case LINKED_ENTITIES_LIST: {
                if (rangeValidator != null) {
                    if (rangeValidator.max() != Double.MIN_VALUE) {
                        this.attributes.max = rangeValidator.max();
                    }
                    if (rangeValidator.min() != Double.MAX_VALUE) {
                        this.attributes.min = rangeValidator.min();
                    }
                }
                this.attributes.readonly = null;
                break;
            }
        }
    }

    @JsonIgnore(value=true)
    private boolean _isReadonly() {
        if (this.desc.getType() instanceof ListTypeDesc) {
            return true;
        }
        UIProperty fa = (UIProperty)this.desc.getAnnotation(UIProperty.class);
        if (fa != null && fa.readonly() != UIProperty.TriBool.UNDEF) {
            return fa.readonly() == UIProperty.TriBool.TRUE;
        }
        return !this.desc.canSet();
    }

    @JsonIgnore(value=true)
    private Boolean _isRequired() {
        Id ida = (Id)this.desc.getAnnotation(Id.class);
        if (ida != null) {
            return true;
        }
        Column ca = (Column)this.desc.getAnnotation(Column.class);
        if (ca != null && !ca.nullable()) {
            return true;
        }
        JoinColumn ja = (JoinColumn)this.desc.getAnnotation(JoinColumn.class);
        if (ja != null && !ja.nullable()) {
            return true;
        }
        ManyToOne ma = (ManyToOne)this.desc.getAnnotation(ManyToOne.class);
        if (ma != null && !ma.optional()) {
            return true;
        }
        UIProperty fa = (UIProperty)this.desc.getAnnotation(UIProperty.class);
        if (fa != null && fa.required()) {
            return true;
        }
        return false;
    }

    private final Double _getLengthFromAnnotation() {
        Column c = (Column)this.desc.getAnnotation(Column.class);
        if (c != null) {
            return c.length();
        }
        return null;
    }

    public static PropertyModelBuilder build(BeanPropertyDesc desc) {
        PropertyModelBuilder ret = new PropertyModelBuilder();
        ret.desc = desc;
        ret.parse();
        if (ret.getName() != null) {
            return ret;
        }
        return null;
    }

    String getName() {
        return this.name;
    }

    private FieldType findSimpleType(NativeTypeDesc<?> ntype) {
        if (ntype.isInt() || ntype.isLong() || ntype.isShort() || ntype.isByte()) {
            if (this.desc.getAnnotation(Id.class) != null) {
                this.attributes.readonly = true;
                return FieldType.ID_INTEGER;
            }
            return FieldType.INTEGER;
        }
        if (ntype.isBoolean()) {
            return FieldType.BOOLEAN;
        }
        if (ntype.isFloat() || ntype.isDouble()) {
            return FieldType.FLOAT;
        }
        if (ntype.isString()) {
            if (this.desc.getAnnotation(Id.class) != null) {
                return FieldType.ID_STRING;
            }
            if (IComplexIdEntity.class.isAssignableFrom(this.desc.getBeanType().getType()) && this.desc.getName().equals("complexId")) {
                return FieldType.ID_STRING;
            }
            Column ca = (Column)this.desc.getAnnotation(Column.class);
            if (ca != null) {
                if (ca.length() <= 128) {
                    return FieldType.TEXT;
                }
                this.attributes.max = ca.length();
            }
            return FieldType.TEXT_LONG;
        }
        if (ntype.isDate()) {
            return FieldType.DATE;
        }
        return null;
    }

    private FieldType findBeanType(BeanTypeDesc<?> btype) {
        EntityTypeExt eext = (EntityTypeExt)btype.getExtension(EntityTypeExt.class);
        if (eext != null && this.desc.getType().getExtension(EntityTypeExt.class) != null) {
            if (eext.getIDFields().size() == 1) {
                this.setRefTypeProperty(btype);
                return FieldType.OBJECT_REF;
            }
            if (eext.getBeanType().getAnnotation(EntityInstantiator.class) != null) {
                this.setRefTypeProperty(btype);
                return FieldType.OBJECT_REF;
            }
            return null;
        }
        return null;
    }

    private void setRefTypeProperty(BeanTypeDesc<?> btype) {
        EntityTypeExt eext = (EntityTypeExt)btype.getExtension(EntityTypeExt.class);
        if (eext != null && this.desc.getType().getExtension(EntityTypeExt.class) != null) {
            if (eext.getIDFields().size() == 1) {
                this.attributes.referencedEntityName = eext.getEntityName();
            } else {
                IEntityInstantiator ei = eext.getInstantiator();
                if (ei != null) {
                    this.attributes.referencedEntityName = eext.getEntityName();
                }
            }
        }
    }

    public static final String getEntityName(Class<?> type) {
        JavaTypeDesc t = JavaTypeRegistry.getType(type);
        EntityTypeExt e = (EntityTypeExt)t.getExtension(EntityTypeExt.class);
        if (e != null) {
            return e.getEntityName();
        }
        return t.getType().getSimpleName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FieldType findListType(ListTypeDesc type) {
        EntityTypeExt olEntity;
        OneToMany otma = (OneToMany)this.desc.getAnnotation(OneToMany.class);
        if (otma == null) return null;
        JavaTypeDesc targetType = null;
        if (otma.targetEntity() == Void.TYPE) {
            Type rawType = this.desc.getRawGetterType();
            if (rawType == null) {
                return null;
            }
            if (rawType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)rawType;
                if (pt.getActualTypeArguments() == null || pt.getActualTypeArguments().length != 1) {
                    return null;
                }
                if (!(pt.getActualTypeArguments()[0] instanceof Class)) return null;
                targetType = JavaTypeRegistry.getType((Class)((Class)pt.getActualTypeArguments()[0]));
            }
        } else {
            targetType = JavaTypeRegistry.getType((Class)otma.targetEntity());
        }
        if ((olEntity = (EntityTypeExt)targetType.getExtension(EntityTypeExt.class)) == null) {
            return null;
        }
        this.attributes.referencedEntityName = olEntity.getEntityName();
        UIProperty fld = (UIProperty)this.desc.getAnnotation(UIProperty.class);
        if (fld != null && fld.mappedBy().length() > 0) {
            this.attributes.mappedBy = fld.mappedBy();
        }
        if (otma.mappedBy().length() <= 0 || this.attributes.mappedBy != null) return FieldType.LINKED_ENTITIES_LIST;
        this.attributes.mappedBy = otma.mappedBy();
        return FieldType.LINKED_ENTITIES_LIST;
    }

    private FieldType findEnumType(EnumTypeDesc<?> type) {
        this.attributes.referencedEnumName = type.getName();
        return FieldType.ENUM;
    }

    private FieldType findType() {
        FieldType ret;
        UIProperty typeAnnotation = (UIProperty)this.desc.getAnnotation(UIProperty.class);
        if (typeAnnotation != null && (ret = typeAnnotation.type()) != FieldType.AUTO) {
            return ret;
        }
        JavaTypeDesc fieldType = this.desc.getType();
        if (fieldType instanceof EnumTypeDesc) {
            return this.findEnumType((EnumTypeDesc)fieldType);
        }
        if (fieldType instanceof NativeTypeDesc) {
            return this.findSimpleType((NativeTypeDesc)fieldType);
        }
        if (fieldType instanceof ListTypeDesc) {
            return this.findListType((ListTypeDesc)fieldType);
        }
        if (fieldType instanceof BeanTypeDesc) {
            return this.findBeanType((BeanTypeDesc)fieldType);
        }
        return null;
    }
}

