/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.inveed.commons.reflection.BeanPropertyDesc;
import net.inveed.commons.reflection.BeanTypeDesc;
import net.inveed.gwt.editor.shared.EntityEditorDTO;
import net.inveed.gwt.editor.shared.EntityEditorsDTO;
import net.inveed.gwt.editor.shared.EntityModelDTO;
import net.inveed.gwt.editor.shared.PropertyModelDTO;
import net.inveed.gwt.server.EntityAccessServiceBuilder;
import net.inveed.gwt.server.EntityEditorBuilder;
import net.inveed.gwt.server.PropertyModelBuilder;
import net.inveed.gwt.server.annotations.JsonRPCServiceRef;
import net.inveed.gwt.server.annotations.UILinkedEntity;
import net.inveed.gwt.server.annotations.UILinkedEntityCreateArg;
import net.inveed.gwt.server.annotations.editor.UIEditor;
import net.inveed.gwt.server.annotations.editor.UIEditorPanel;
import net.inveed.gwt.server.annotations.editor.UIEditorSection;
import net.inveed.gwt.server.annotations.editor.UIEditors;
import net.inveed.rest.jpa.annotations.TypeDescriminator;
import net.inveed.rest.jpa.annotations.TypeDescriminatorField;
import net.inveed.rest.jpa.typeutils.EntityTypeExt;

public class EntityModelBuilder {
    private final BeanTypeDesc<?> bean;
    public String entityName;
    public String typeDescriminator;
    public String superType;
    public boolean isAbstract;
    public String typeDescriminatorField;
    public boolean typeOnUpdate;
    public EntityAccessServiceBuilder service = new EntityAccessServiceBuilder();
    public Map<String, PropertyModelBuilder> properties = new HashMap<String, PropertyModelBuilder>();
    public Map<String, EntityEditorBuilder> editors = new HashMap<String, EntityEditorBuilder>();

    public static EntityModelDTO build(BeanTypeDesc<?> bean) {
        EntityModelBuilder bld = new EntityModelBuilder(bean);
        bld.parse();
        return bld.build();
    }

    public EntityModelBuilder(BeanTypeDesc<?> bean) {
        this.bean = bean;
    }

    public EntityModelDTO build() {
        if (this.entityName == null) {
            return null;
        }
        HashMap<String, PropertyModelDTO> flds = new HashMap<String, PropertyModelDTO>();
        for (String k : this.properties.keySet()) {
            PropertyModelBuilder fb = this.properties.get(k);
            PropertyModelDTO fm = fb.build();
            if (fm == null) continue;
            flds.put(k, fm);
        }
        EntityEditorsDTO ees = null;
        if (this.editors.size() > 0) {
            HashMap<String, EntityEditorDTO> eedtoMap = new HashMap<String, EntityEditorDTO>();
            for (String k : this.editors.keySet()) {
                EntityEditorDTO eedto = this.editors.get(k).build();
                eedtoMap.put(k, eedto);
            }
            ees = new EntityEditorsDTO(eedtoMap);
        }
        return new EntityModelDTO(this.entityName, this.typeDescriminator, this.superType, this.isAbstract, this.typeDescriminatorField, this.typeOnUpdate, this.service.build(), ees, flds);
    }

    private void parseProperties() {
        Collection<Object> props = null;
        props = this.superType != null ? this.bean.getDeclaredProperties().values() : this.bean.getProperties();
        for (BeanPropertyDesc beanPropertyDesc : props) {
            EntityEditorBuilder eeb;
            UIEditorPanel tca;
            EntityEditorBuilder eeb2;
            UIEditorSection fca;
            if (beanPropertyDesc.getAnnotation(JsonIgnore.class) != null) continue;
            PropertyModelBuilder f = PropertyModelBuilder.build(beanPropertyDesc);
            if (f != null) {
                this.properties.put(f.getName(), f);
            }
            if ((fca = (UIEditorSection)beanPropertyDesc.getAnnotation(UIEditorSection.class)) != null && (eeb2 = this.getEntityEditorBuilder(fca.viewName())) != null) {
                eeb2.registerAnnotation(fca);
            }
            if ((tca = (UIEditorPanel)beanPropertyDesc.getAnnotation(UIEditorPanel.class)) == null || (eeb = this.getEntityEditorBuilder(tca.viewName())) == null) continue;
            eeb.registerAnnotation(tca);
        }
    }

    private EntityEditorBuilder getEntityEditorBuilder(String view) {
        if (view == null) {
            return null;
        }
        if ((view = view.trim()).length() < 1) {
            return null;
        }
        EntityEditorBuilder ret = this.editors.get(view);
        if (ret == null) {
            ret = new EntityEditorBuilder();
            this.editors.put(view, ret);
        }
        return ret;
    }

    private void parseEditors() {
        UIEditor ea;
        HashMap<String, UIEditor> m = new HashMap<String, UIEditor>();
        UIEditors eas = (UIEditors)this.bean.getAnnotation(UIEditors.class);
        if (eas != null) {
            for (UIEditor e : eas.value()) {
                m.put(e.viewName(), e);
            }
        }
        if ((ea = (UIEditor)this.bean.getAnnotation(UIEditor.class)) != null) {
            m.put(ea.viewName(), ea);
        }
        for (String k : m.keySet()) {
            UIEditor e;
            e = (UIEditor)m.get(k);
            EntityEditorBuilder eb = this.getEntityEditorBuilder(k);
            eb.registerAnnotation(e);
        }
    }

    private void parseSupertype() {
        EntityTypeExt ete;
        if (this.bean.getSupertype() == null) {
            return;
        }
        EntityTypeExt ee = (EntityTypeExt)this.bean.getSupertype().getExtension(EntityTypeExt.class);
        if (ee == null) {
            return;
        }
        if (ee.isMappedSuperclass()) {
            return;
        }
        this.superType = ee.getEntityName();
        TypeDescriminator tda = (TypeDescriminator)this.bean.getAnnotation(TypeDescriminator.class);
        this.typeDescriminator = tda != null ? tda.value() : ((ete = (EntityTypeExt)this.bean.getExtension(EntityTypeExt.class)) != null ? ete.getEntityName() : this.bean.getShortName().trim());
    }

    private void parse() {
        this.parseSupertype();
        this.parseProperties();
        JsonRPCServiceRef srefa = (JsonRPCServiceRef)this.bean.getAnnotation(JsonRPCServiceRef.class);
        if (srefa != null) {
            EntityAccessServiceBuilder easb = new EntityAccessServiceBuilder();
            easb.service = srefa.value();
            easb.methodCreate = srefa.methodCreate();
            easb.methodDelete = srefa.methodDelete();
            easb.methodUpdate = srefa.methodUpdate();
            easb.methodList = srefa.methodList();
            easb.methodGet = srefa.methodGet();
            easb.argData = srefa.argData();
            easb.argId = srefa.argID();
            easb.argPage = srefa.argPage();
            easb.argPageSize = srefa.argPageSize();
            UILinkedEntity mla = (UILinkedEntity)this.bean.getAnnotation(UILinkedEntity.class);
            if (mla != null) {
                easb.createArgs = new HashMap<String, String>();
                for (UILinkedEntityCreateArg i : mla.items()) {
                    String prop = i.property().trim();
                    if (prop.length() == 0) {
                        prop = i.createArg();
                    }
                    easb.createArgs.put(i.createArg(), prop);
                }
            }
            this.service = easb;
        }
        if (this.superType == null && !Modifier.isFinal(this.bean.getType().getModifiers())) {
            TypeDescriminatorField tdfa = (TypeDescriminatorField)this.bean.getAnnotation(TypeDescriminatorField.class);
            if (tdfa == null && this.bean.getAnnotation(JsonSubTypes.class) != null && this.bean.getAnnotation(JsonTypeInfo.class) != null) {
                JsonTypeInfo ti = (JsonTypeInfo)this.bean.getAnnotation(JsonTypeInfo.class);
                if (ti.include() == JsonTypeInfo.As.PROPERTY) {
                    this.typeDescriminatorField = ti.property();
                    this.typeOnUpdate = true;
                } else {
                    this.typeDescriminatorField = "#type";
                }
            } else {
                this.typeDescriminatorField = tdfa != null ? tdfa.value() : "#type";
            }
        }
        this.entityName = PropertyModelBuilder.getEntityName(this.bean.getType());
        this.isAbstract = Modifier.isAbstract(this.bean.getType().getModifiers());
        this.parseEditors();
    }
}

