/*
 * Decompiled with CFR 0.152.
 */
package net.innig.sweetxml.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.innig.sweetxml.ConversionMode;
import net.innig.sweetxml.FileConverterEngine;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SweetXmlTask
extends Task {
    private ConversionMode mode = ConversionMode.S2X;
    private List<FileSet> inputFilesSets = new ArrayList<FileSet>();
    private File outputDir;
    private boolean quiet;
    private boolean overwrite = true;
    private boolean deleteSources;

    public void execute() throws BuildException {
        if (this.inputFilesSets.isEmpty()) {
            throw new BuildException("The SweetXML task requires a nested inputFileSet element");
        }
        FileConverterEngine converter = new FileConverterEngine(this.overwrite, this.quiet);
        for (FileSet inputFiles : this.inputFilesSets) {
            DirectoryScanner inScanner = inputFiles.getDirectoryScanner(this.getProject());
            File inputDir = inScanner.getBasedir();
            if (this.outputDir == null) {
                this.outputDir = inputDir;
            }
            for (String inFilePath : inScanner.getIncludedFiles()) {
                File inFile = new File(inputDir, inFilePath);
                File outFile = converter.outputFileFor(new File(this.outputDir, inFilePath), this.mode);
                try {
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    converter.convertFile(inFile, outFile, this.mode);
                }
                catch (Exception e) {
                    String sep = System.getProperty("line.separator");
                    throw new BuildException("Unable to perform SweetXML conversion" + sep + "  from: " + inFile + sep + "    to: " + outFile + sep + "Reason: " + e, (Throwable)e);
                }
                if (!this.deleteSources) continue;
                inFile.delete();
            }
        }
    }

    public void setMode(String mode) throws BuildException {
        try {
            this.mode = ConversionMode.valueOf((String)mode.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new BuildException("No such mode \"" + mode + "\"; expected \"x2s\" or \"s2x\"");
        }
    }

    public void addConfiguredInputFileSet(FileSet inputFiles) throws IOException {
        this.inputFilesSets.add(inputFiles);
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setDeleteSources(boolean deleteSources) {
        this.deleteSources = deleteSources;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }
}

