/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.view.creator;

import net.infumia.frame.util.PaperLib;
import net.infumia.frame.view.creator.InventoryFactory;
import net.infumia.frame.view.creator.InventoryFactoryPaper;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryFactoryBukkit
implements InventoryFactory {
    public static final InventoryFactory INSTANCE = new InventoryFactoryBukkit();

    @NotNull
    public static InventoryFactory bukkitOrPaper() {
        if (PaperLib.isPaper() && PaperLib.isVersion(16)) {
            return InventoryFactoryPaper.INSTANCE;
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    public Inventory create(@Nullable InventoryHolder holder, @NotNull InventoryType type, int size, @Nullable Object title) {
        String titleAsText;
        if (title instanceof String && !((String)title).isEmpty()) {
            titleAsText = (String)title;
        } else {
            if (title != null) {
                throw new IllegalArgumentException(String.format("Title must be only either String or null '%s'", title));
            }
            titleAsText = type.getDefaultTitle();
        }
        return size == 0 ? Bukkit.createInventory((InventoryHolder)holder, (InventoryType)type, (String)titleAsText) : Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)titleAsText);
    }

    protected InventoryFactoryBukkit() {
    }
}

