/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.util;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class PaperLib {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?i)\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?(?: (Pre-Release|Release Candidate) )?(\\d)?\\)");
    private static final Environment environment = PaperLib.initialize();

    public static boolean isVersion(int minor) {
        return PaperLib.isVersion(minor, 0);
    }

    public static boolean isVersion(int minor, int patch) {
        return PaperLib.minor() > minor || PaperLib.minor() >= minor && PaperLib.patch() >= patch;
    }

    public static int major() {
        return environment.major;
    }

    public static int minor() {
        return environment.minor;
    }

    public static int patch() {
        return environment.patch;
    }

    public static boolean isPaper() {
        return environment.isPaper;
    }

    @NotNull
    private static Environment initialize() {
        Matcher matcher = VERSION_PATTERN.matcher(Bukkit.getVersion());
        int major = 1;
        int minor = 0;
        int patch = 0;
        if (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            try {
                major = Integer.parseInt(matchResult.group(1), 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                minor = Integer.parseInt(matchResult.group(2), 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (matchResult.groupCount() >= 3) {
                try {
                    patch = Integer.parseInt(matchResult.group(3), 10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (PaperLib.hasClass("com.destroystokyo.paper.PaperConfig") || PaperLib.hasClass("io.papermc.paper.configuration.Configuration")) {
            return new Environment(major, minor, patch, true);
        }
        return new Environment(major, minor, patch, false);
    }

    private static boolean hasClass(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static final class Environment {
        private final int major;
        private final int minor;
        private final int patch;
        private final boolean isPaper;

        private Environment(int major, int minor, int patch, boolean isPaper) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.isPaper = isPaper;
        }
    }
}

