/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.service;

import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.infumia.frame.Preconditions;
import net.infumia.frame.service.Cancellable;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.service.Service;
import net.infumia.frame.service.ServicePipeline;
import net.infumia.frame.service.ServiceRepository;
import net.infumia.frame.service.ServiceWrapper;

final class ServiceSpigot<Context, Result> {
    private final ServicePipeline pipeline;
    private final ServiceRepository<Context, Result> repository;
    private final Context context;

    ServiceSpigot(ServicePipeline pipeline, ServiceRepository<Context, Result> repository, Context context) {
        this.pipeline = pipeline;
        this.repository = repository;
        this.context = context;
    }

    CompletableFuture<Result> complete() {
        return this.completeInternally(Runnable::run);
    }

    CompletableFuture<Result> completeAsync() {
        return this.completeInternally(this.pipeline.executor);
    }

    private CompletableFuture<Result> completeInternally(Executor executor) {
        CompletableFuture future = new CompletableFuture();
        ScheduledFuture delayer = this.scheduleTimeout(future);
        AtomicBoolean isConsumerService = new AtomicBoolean(false);
        executor.execute(() -> this.processServices(isConsumerService).whenComplete((result, throwable) -> {
            if (delayer.cancel(true)) {
                if (throwable == null) {
                    future.complete(result);
                } else {
                    future.completeExceptionally((Throwable)throwable);
                }
            }
        }));
        return future.thenApply(result -> this.checkFinalResult(isConsumerService, result));
    }

    private CompletableFuture<Result> processServices(AtomicBoolean isConsumerService) {
        ServiceWrapper<Context, Result> wrapper;
        CompletableFuture<Object> job = CompletableFuture.completedFuture(null);
        LinkedList<ServiceWrapper<Context, Result>> queue = this.repository.queue();
        while ((wrapper = queue.pollLast()) != null) {
            job = this.processService(isConsumerService, wrapper, job);
        }
        return job;
    }

    private CompletableFuture<Result> processService(AtomicBoolean isConsumerService, ServiceWrapper<Context, Result> wrapper, CompletableFuture<Result> job) {
        Service service = wrapper.implementation;
        isConsumerService.set(service instanceof ConsumerService);
        if (!wrapper.passes(this.context)) {
            return job;
        }
        return job.thenCompose(result -> this.shouldContinue(isConsumerService, result) ? service.handle(this.context) : CompletableFuture.completedFuture(result));
    }

    private boolean shouldContinue(AtomicBoolean isConsumerService, Result result) {
        if (this.isCancelled()) {
            return false;
        }
        if (result == null) {
            return true;
        }
        return isConsumerService.get() && result != ConsumerService.State.FINISHED;
    }

    private Result checkFinalResult(AtomicBoolean isConsumerService, Result result) {
        if (isConsumerService.get()) {
            return (Result)((Object)ConsumerService.State.FINISHED);
        }
        return (Result)Preconditions.argumentNotNull(result, (String)"No service consumed the context.", (Object[])new Object[0]);
    }

    private boolean isCancelled() {
        return this.context instanceof Cancellable && ((Cancellable)this.context).cancelled();
    }

    private ScheduledFuture<?> scheduleTimeout(CompletableFuture<?> future) {
        return this.pipeline.delayer.schedule(() -> this.tryTimeout(future), this.pipeline.timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void tryTimeout(CompletableFuture<?> future) {
        if (future.isDone()) {
            return;
        }
        future.completeExceptionally(new TimeoutException(String.format("Service '%s' could not complete in time %sms", this.repository.serviceType.getType().getTypeName(), this.pipeline.timeout.toMillis())));
    }
}

