/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.service;

import io.leangen.geantyref.TypeToken;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.infumia.frame.Cloned;
import net.infumia.frame.Preconditions;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.service.Service;
import net.infumia.frame.service.ServicePipeline;
import net.infumia.frame.service.ServiceSpigot;
import net.infumia.frame.service.ServiceWrapper;

public final class ServiceRepository<Context, Result>
implements Cloned<ServiceRepository<Context, Result>> {
    private final ServicePipeline pipeline;
    final TypeToken<? extends Service<Context, Result>> serviceType;
    final List<ServiceWrapper<Context, Result>> implementations;

    private ServiceRepository(ServicePipeline pipeline, TypeToken<? extends Service<Context, Result>> serviceType, List<ServiceWrapper<Context, Result>> implementations) {
        this.pipeline = (ServicePipeline)Preconditions.argumentNotNull((Object)pipeline, (String)"pipeline", (Object[])new Object[0]);
        this.serviceType = (TypeToken)Preconditions.argumentNotNull(serviceType, (String)"serviceType", (Object[])new Object[0]);
        this.implementations = (List)Preconditions.argumentNotNull(implementations, (String)"implementations", (Object[])new Object[0]);
    }

    public ServiceRepository(ServicePipeline pipeline, TypeToken<? extends Service<Context, Result>> serviceType, Service<Context, Result> defaultImplementation) {
        this.pipeline = (ServicePipeline)Preconditions.argumentNotNull((Object)pipeline, (String)"pipeline", (Object[])new Object[0]);
        this.serviceType = (TypeToken)Preconditions.argumentNotNull(serviceType, (String)"serviceType", (Object[])new Object[0]);
        Service defImpl = (Service)Preconditions.argumentNotNull(defaultImplementation, (String)"defaultImplementation", (Object[])new Object[0]);
        this.implementations = new LinkedList<ServiceWrapper<Context, Result>>();
        this.implementations.add(new ServiceWrapper(serviceType, defImpl, true, null));
    }

    public ServiceRepository<Context, Result> cloned() {
        return new ServiceRepository<Context, Result>(this.pipeline, this.serviceType, new LinkedList<ServiceWrapper<Context, Result>>(this.implementations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Implementation<Context, Result> operation) {
        Preconditions.argumentNotNull(operation, (String)"operation", (Object[])new Object[0]);
        List<ServiceWrapper<Context, Result>> list = this.implementations;
        synchronized (list) {
            operation.handle(this);
        }
    }

    public CompletableFuture<Result> completeDirect(Context context) {
        Preconditions.argumentNotNull(context, (String)"context", (Object[])new Object[0]);
        return new ServiceSpigot(this.pipeline, this, context).complete();
    }

    public CompletableFuture<Result> completeAsync(Context context) {
        Preconditions.argumentNotNull(context, (String)"context", (Object[])new Object[0]);
        return new ServiceSpigot(this.pipeline, this, context).completeAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedList<ServiceWrapper<Context, Result>> queue() {
        List<ServiceWrapper<Context, Result>> list = this.implementations;
        synchronized (list) {
            return this.implementations.stream().sorted().collect(Collectors.toCollection(LinkedList::new));
        }
    }
}

