/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.service;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.infumia.frame.Preconditions;
import net.infumia.frame.service.ServicePipeline;

public final class ServicePipelineBuilder {
    private Executor executor = Executors.newSingleThreadExecutor();
    private Duration timeout = Duration.ofSeconds(10L);
    private ScheduledExecutorService delayer = Executors.newScheduledThreadPool(1);

    public static ServicePipelineBuilder newBuilder() {
        return new ServicePipelineBuilder();
    }

    public ServicePipelineBuilder executor(Executor executor) {
        this.executor = (Executor)Preconditions.argumentNotNull((Object)executor, (String)"executor", (Object[])new Object[0]);
        return this;
    }

    public ServicePipelineBuilder timeout(Duration timeout) {
        this.timeout = (Duration)Preconditions.argumentNotNull((Object)timeout, (String)"timeout", (Object[])new Object[0]);
        return this;
    }

    public ServicePipelineBuilder delayer(ScheduledExecutorService delayer) {
        this.delayer = (ScheduledExecutorService)Preconditions.argumentNotNull((Object)delayer, (String)"delayer", (Object[])new Object[0]);
        return this;
    }

    public ServicePipeline build() {
        return new ServicePipeline(this.executor, this.timeout, this.delayer);
    }

    private ServicePipelineBuilder() {
    }
}

