/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.service;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.service.Service;
import net.infumia.frame.service.ServiceRepository;
import net.infumia.frame.service.ServiceWrapper;

final class Replace<Context, Result>
implements Implementation<Context, Result> {
    private final String serviceKey;
    private final UnaryOperator<Service<Context, Result>> service;
    private final Collection<Predicate<Context>> filters;

    Replace(String serviceKey, UnaryOperator<Service<Context, Result>> service, Collection<Predicate<Context>> filters) {
        this.serviceKey = serviceKey;
        this.service = service;
        this.filters = filters;
    }

    @Override
    public void handle(ServiceRepository<Context, Result> repository) {
        List implementations = repository.implementations;
        ListIterator iterator = implementations.listIterator();
        while (iterator.hasNext()) {
            Service oldImplementation = iterator.next().implementation;
            if (!oldImplementation.key().equals(this.serviceKey)) continue;
            iterator.set(new ServiceWrapper(repository.serviceType, (Service)this.service.apply(oldImplementation), false, this.filters));
            return;
        }
        throw new IllegalArgumentException(String.format("Service '%s' not found in the implementation list '%s'!", this.serviceKey, implementations.stream().map(wrapper -> wrapper.implementation).map(Service::key).collect(Collectors.toSet())));
    }
}

