/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.service;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.service.Service;
import net.infumia.frame.service.ServiceRepository;
import net.infumia.frame.service.ServiceWrapper;

final class RegisterBefore<Context, Result>
implements Implementation<Context, Result> {
    private final String serviceKey;
    private final Service<Context, Result> service;
    private final Collection<Predicate<Context>> filters;

    RegisterBefore(String serviceKey, Service<Context, Result> service, Collection<Predicate<Context>> filters) {
        this.serviceKey = serviceKey;
        this.service = service;
        this.filters = filters;
    }

    @Override
    public void handle(ServiceRepository<Context, Result> repository) {
        List implementations = repository.implementations;
        ListIterator iterator = implementations.listIterator();
        while (iterator.hasNext()) {
            ServiceWrapper next = iterator.next();
            if (!next.implementation.key().equals(this.serviceKey)) continue;
            iterator.add(new ServiceWrapper<Context, Result>(repository.serviceType, this.service, false, this.filters));
            return;
        }
        throw new IllegalArgumentException(String.format("Service '%s' not found in the implementation list '%s'!", this.serviceKey, implementations.stream().map(wrapper -> wrapper.implementation).map(Service::key).collect(Collectors.toSet())));
    }
}

