/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.service;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.infumia.frame.Preconditions;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.service.Service;
import net.infumia.frame.service.ServiceRepository;
import net.infumia.frame.service.ServiceWrapper;

final class RegisterAfter<Context, Result>
implements Implementation<Context, Result> {
    private final String serviceKey;
    private final Service<Context, Result> service;
    private final Collection<Predicate<Context>> filters;

    RegisterAfter(String serviceKey, Service<Context, Result> service, Collection<Predicate<Context>> filters) {
        this.serviceKey = serviceKey;
        this.service = service;
        this.filters = filters;
    }

    @Override
    public void handle(ServiceRepository<Context, Result> repository) {
        List implementations = repository.implementations;
        for (int index = 0; index < implementations.size(); ++index) {
            ServiceWrapper wrapper2 = implementations.get(index);
            Service implementation = wrapper2.implementation;
            if (!implementation.key().equals(this.serviceKey)) continue;
            Preconditions.argument((!wrapper2.defaultImplementation ? 1 : 0) != 0, (String)"You cannot put an implementation before the default implementation! Try to replace it instead.", (Object[])new Object[0]);
            implementations.add(index, new ServiceWrapper<Context, Result>(repository.serviceType, this.service, false, this.filters));
            return;
        }
        throw new IllegalArgumentException(String.format("Service '%s' not found in the implementation list '%s'!", this.serviceKey, implementations.stream().map(wrapper -> wrapper.implementation).map(Service::key).collect(Collectors.toSet())));
    }
}

