/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.service;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.infumia.frame.Preconditions;
import net.infumia.frame.service.Service;

public interface ConsumerService<Context>
extends Service<Context, State>,
BiConsumer<CompletableFuture<State>, Context>,
Consumer<Context> {
    @Override
    default public void accept(Context ctx) {
    }

    @Override
    default public void accept(CompletableFuture<State> future, Context ctx) {
        Preconditions.argumentNotNull(future, (String)"future", (Object[])new Object[0]);
        this.accept(ctx);
        future.complete(State.CONTINUE);
    }

    @Override
    default public CompletableFuture<State> handle(Context ctx) {
        CompletableFuture<State> future = new CompletableFuture<State>();
        try {
            this.accept(future, ctx);
        }
        catch (Throwable throwable) {
            future.completeExceptionally(throwable);
        }
        return future;
    }

    public static enum State {
        CONTINUE,
        FINISHED;

    }
}

