/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.service.element;

import java.time.Duration;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.infumia.frame.context.element.ContextElementClick;
import net.infumia.frame.element.ElementRich;
import net.infumia.frame.metadata.MetadataAccess;
import net.infumia.frame.metadata.MetadataKeyHolder;
import net.infumia.frame.pipeline.PipelineServiceConsumer;
import net.infumia.frame.pipeline.context.PipelineContextElement;
import net.infumia.frame.viewer.ContextualViewer;
import org.jetbrains.annotations.NotNull;

public final class ServiceClickInteractionDelay
implements PipelineServiceConsumer<PipelineContextElement.Click> {
    public static final PipelineServiceConsumer<PipelineContextElement.Click> INSTANCE = new ServiceClickInteractionDelay();
    public static final String KEY = "interaction-delay";

    @NotNull
    public String key() {
        return KEY;
    }

    public void accept(@NotNull PipelineContextElement.Click ctx) {
        Function interactionDelayKey;
        ContextElementClick context = ctx.context();
        ElementRich element = (ElementRich)context.element();
        Duration delay = element.interactionDelay();
        if (delay == null || delay.isZero() || delay.isNegative()) {
            return;
        }
        ContextualViewer clicker = context.clicker();
        MetadataAccess metadata = clicker.metadata();
        HashMap<String, Long> lastInteractions = (HashMap<String, Long>)metadata.get(MetadataKeyHolder.LAST_INTERACTION_ELEMENT);
        if (lastInteractions == null) {
            lastInteractions = new HashMap<String, Long>();
            metadata.setFixed(MetadataKeyHolder.LAST_INTERACTION_ELEMENT, lastInteractions);
        }
        String key = (interactionDelayKey = element.interactionDelayKey()) == null ? (String)element.key() : (String)interactionDelayKey.apply(context);
        Long lastInteraction = (Long)lastInteractions.get(key);
        long now = System.currentTimeMillis();
        if (lastInteraction == null) {
            lastInteractions.put(key, now);
            return;
        }
        long elapsed = now - lastInteraction;
        if (elapsed > delay.toMillis()) {
            lastInteractions.put(key, now);
        } else {
            context.frame().logger().debug("Click event of viewer '%s' cancelled due to interaction delay.", new Object[]{clicker});
            ctx.cancelled(true);
            context.cancelled(true);
            Consumer onInteractionDelay = element.onInteractionDelay();
            if (onInteractionDelay != null) {
                onInteractionDelay.accept(context);
            }
        }
    }

    private ServiceClickInteractionDelay() {
    }
}

