/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.element.ContextElementClick;
import net.infumia.frame.context.element.ContextElementRender;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.ElementBuilderRich;
import net.infumia.frame.element.ElementImpl;
import net.infumia.frame.element.ElementRich;
import net.infumia.frame.state.State;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementBuilderImpl<Self extends ElementBuilderImpl<Self>>
implements ElementBuilderRich {
    Element root;
    boolean cancelOnClick;
    boolean closeOnClick;
    boolean updateOnClick;
    Duration interactionDelay;
    Consumer<ContextElementClick> onInteractionDelay;
    Function<ContextElementClick, String> interactionDelayKey;
    Predicate<ContextElementRender> displayIf;
    Collection<State<?>> updateOnStateChange;
    Collection<State<?>> updateOnStateAccess;

    public ElementBuilderImpl(@NotNull Element element) {
        this.root = ((ElementRich)element).root();
        this.cancelOnClick = element.cancelOnClick();
        this.closeOnClick = element.closeOnClick();
        this.updateOnClick = element.updateOnClick();
        this.interactionDelay = element.interactionDelay();
        this.onInteractionDelay = element.onInteractionDelay();
        this.displayIf = element.displayIf();
        this.updateOnStateChange = element.updateOnStateChange();
        this.updateOnStateAccess = element.updateOnStateAccess();
    }

    public ElementBuilderImpl() {
    }

    @NotNull
    public Self root(@NotNull Element root) {
        this.root = root;
        return this.self();
    }

    @Override
    @NotNull
    public Element build(@NotNull ContextBase context) {
        return new ElementImpl(this, context);
    }

    @NotNull
    public Self cancelOnClick() {
        return (Self)this.cancelOnClick(true);
    }

    @NotNull
    public Self closeOnClick() {
        return (Self)this.closeOnClick(true);
    }

    @NotNull
    public Self updateOnClick() {
        return (Self)this.updateOnClick(true);
    }

    @NotNull
    public Self cancelOnClick(boolean cancelOnClick) {
        this.cancelOnClick = cancelOnClick;
        return this.self();
    }

    @NotNull
    public Self closeOnClick(boolean cancelOnClick) {
        this.closeOnClick = cancelOnClick;
        return this.self();
    }

    @NotNull
    public Self updateOnClick(boolean updateOnClick) {
        this.updateOnClick = updateOnClick;
        return this.self();
    }

    @NotNull
    public Self interactionDelay(@Nullable Duration interactionDelay) {
        this.interactionDelay = interactionDelay;
        return this.self();
    }

    @NotNull
    public Self onInteractionDelay(@NotNull Consumer<ContextElementClick> onInteractionDelay) {
        this.onInteractionDelay = onInteractionDelay;
        return this.self();
    }

    @NotNull
    public Self interactionDelayKey(@NotNull Function<ContextElementClick, String> interactionDelayKey) {
        this.interactionDelayKey = interactionDelayKey;
        return this.self();
    }

    @NotNull
    public Self updateOnStateChange(@NotNull State<?> state, State<?> ... otherStates) {
        if (this.updateOnStateChange == null) {
            this.updateOnStateChange = new HashSet();
        }
        this.updateOnStateChange.add(state);
        Collections.addAll(this.updateOnStateChange, otherStates);
        return this.self();
    }

    @NotNull
    public Self updateOnStateAccess(@NotNull State<?> state, State<?> ... otherStates) {
        if (this.updateOnStateAccess == null) {
            this.updateOnStateAccess = new HashSet();
        }
        this.updateOnStateAccess.add(state);
        Collections.addAll(this.updateOnStateAccess, otherStates);
        return this.self();
    }

    @NotNull
    public Self displayIf(@NotNull Predicate<ContextElementRender> condition) {
        this.displayIf = condition;
        return this.self();
    }

    @NotNull
    public Self displayIf(@NotNull BooleanSupplier condition) {
        return (Self)this.displayIf(__ -> condition.getAsBoolean());
    }

    @NotNull
    public Self hideIf(@NotNull Predicate<ContextElementRender> condition) {
        return (Self)this.displayIf(ctx -> condition.negate().test((ContextElementRender)ctx));
    }

    @NotNull
    public Self hideIf(@NotNull BooleanSupplier condition) {
        return (Self)this.hideIf(__ -> condition.getAsBoolean());
    }

    @NotNull
    private Self self() {
        return (Self)this;
    }
}

