/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element.pagination;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.ElementEventHandler;
import net.infumia.frame.element.ElementImpl;
import net.infumia.frame.element.ElementItem;
import net.infumia.frame.element.ElementItemBuilder;
import net.infumia.frame.element.ElementItemBuilderImpl;
import net.infumia.frame.element.ElementItemBuilderRich;
import net.infumia.frame.element.ElementRich;
import net.infumia.frame.element.pagination.ElementEventHandlerPagination;
import net.infumia.frame.element.pagination.ElementPagination;
import net.infumia.frame.element.pagination.ElementPaginationBuilder;
import net.infumia.frame.element.pagination.ElementPaginationBuilderImpl;
import net.infumia.frame.element.pagination.ElementPaginationBuilderRich;
import net.infumia.frame.element.pagination.ElementPaginationRich;
import net.infumia.frame.element.pagination.SourceProvider;
import net.infumia.frame.extension.CompletableFutureExtensions;
import net.infumia.frame.pipeline.executor.PipelineExecutorElement;
import net.infumia.frame.pipeline.executor.PipelineExecutorElementImpl;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.slot.LayoutSlot;
import net.infumia.frame.state.State;
import net.infumia.frame.state.pagination.ElementConfigurer;
import net.infumia.frame.state.pagination.StatePagination;
import net.infumia.frame.util.Preconditions;
import net.infumia.frame.view.ViewContainer;
import org.jetbrains.annotations.NotNull;

public final class ElementPaginationImpl<T>
extends ElementImpl
implements ElementPaginationRich<T> {
    private final ReadWriteLock elementLock = new ReentrantReadWriteLock();
    private final PipelineExecutorElement pipelines = new PipelineExecutorElementImpl(this);
    private final ElementEventHandler eventHandler = ElementEventHandlerPagination.INSTANCE;
    private LayoutSlot currentLayoutSlot;
    final SourceProvider<T> sourceProvider;
    final Function<ElementPaginationBuilder<T>, StatePagination> stateFactory;
    final char layout;
    final BiConsumer<ContextBase, ElementPagination> onPageSwitch;
    final ElementConfigurer<T> elementConfigurer;
    final State<ElementPagination> associated;
    private final Function<ContextBase, CompletableFuture<List<T>>> sourceFactory;
    private List<Element> elements = new ArrayList<Element>();
    private int currentPageIndex = 0;
    private boolean pageWasChanged;
    private boolean initialized = false;
    private int pageCount;
    private List<T> currentSource;
    private boolean loading;
    private int pageSize = -1;

    ElementPaginationImpl(@NotNull ElementPaginationBuilderImpl<T> builder, @NotNull ContextBase parent) {
        super(builder, parent);
        this.associated = (State)Preconditions.argumentNotNull(builder.associated, (String)"Associated state cannot be null for ElementPagination!", (Object[])new Object[0]);
        this.elementConfigurer = (ElementConfigurer)Preconditions.argumentNotNull(builder.elementConfigurer, (String)"Element configurer cannot be null for ElementPagination!", (Object[])new Object[0]);
        this.sourceProvider = builder.sourceProvider;
        this.stateFactory = builder.stateFactory;
        this.layout = builder.layout;
        this.onPageSwitch = builder.onPageSwitch;
        if (this.sourceProvider instanceof SourceProvider.Immutable) {
            this.currentSource = (List)((CompletableFuture)this.sourceProvider.apply(this.parent())).join();
            this.sourceFactory = null;
        } else {
            this.sourceFactory = this.sourceProvider;
        }
    }

    @Override
    @NotNull
    public State<ElementPagination> associated() {
        return this.associated;
    }

    @Override
    public boolean pageWasChanged() {
        return this.pageWasChanged;
    }

    @Override
    public void pageWasChanged(boolean pageWasChanged) {
        this.pageWasChanged = pageWasChanged;
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    @Override
    public void initialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public void updatePageSize(@NotNull ContextRender context) {
        String[] layout = context.config().layout();
        this.pageSize = layout == null ? context.container().size() : this.layoutSlotFor(context).slots().length;
    }

    @Override
    @NotNull
    public CompletableFuture<?> loadCurrentPage(@NotNull ContextRender context, boolean forced) {
        return this.loadSourceForTheCurrentPage((ContextBase)context, forced).thenAccept(pageContents -> {
            if (pageContents.isEmpty()) {
                return;
            }
            if (context.layouts().isEmpty()) {
                this.addComponentsForUnconstrainedPagination(context, (List<T>)pageContents);
            } else {
                this.addComponentsForLayeredPagination(context, (List<T>)pageContents);
            }
        });
    }

    @Override
    @NotNull
    public Collection<Element> modifiableElements() {
        try {
            this.elementLock.readLock().lock();
            List<Element> list = this.elements;
            return list;
        }
        finally {
            this.elementLock.readLock().unlock();
        }
    }

    @Override
    public void clearElements() {
        try {
            this.elementLock.writeLock().lock();
            this.elements = new ArrayList<Element>();
        }
        finally {
            this.elementLock.writeLock().unlock();
        }
    }

    public int currentPageIndex() {
        return this.currentPageIndex;
    }

    public int nextPageIndex() {
        return Math.max(0, Math.min(this.pageCount, this.currentPageIndex + 1));
    }

    public int previousPageIndex() {
        return Math.max(0, Math.min(this.pageCount, this.currentPageIndex - 1));
    }

    public int lastPageIndex() {
        return Math.max(0, this.pageCount - 1);
    }

    public boolean isFirstPage() {
        return this.currentPageIndex == 0;
    }

    public boolean isLastPage() {
        return !this.canAdvance();
    }

    public int elementCount() {
        return this.currentSource == null ? 0 : this.currentSource.size();
    }

    public int pageCount() {
        return this.pageCount;
    }

    public boolean hasPage(int pageIndex) {
        if (this.sourceProvider.computed()) {
            return true;
        }
        if (pageIndex < 0) {
            return false;
        }
        return pageIndex < this.pageCount;
    }

    public void switchTo(int pageIndex) {
        Preconditions.argumentNotNull((Object)this.hasPage(pageIndex), (String)"Page index not found (%d > %d)", (Object[])new Object[]{pageIndex, this.pageCount});
        if (this.loading) {
            return;
        }
        this.currentPageIndex = pageIndex;
        this.pageWasChanged = true;
        ContextRender host = (ContextRender)this.parent();
        if (this.onPageSwitch != null) {
            this.onPageSwitch.accept((ContextBase)host, this);
        }
        CompletableFutureExtensions.logError(this.update(), this.parent().frame().logger(), "An error occurred while updating the pagination '%s'.", this);
    }

    public void advance() {
        if (this.canAdvance()) {
            this.switchTo(this.currentPageIndex + 1);
        }
    }

    public boolean canAdvance() {
        return this.hasPage(this.currentPageIndex + 1);
    }

    public void back() {
        if (this.canBack()) {
            this.switchTo(this.currentPageIndex - 1);
        }
    }

    public boolean canBack() {
        return this.hasPage(this.currentPageIndex - 1);
    }

    @Override
    @NotNull
    public ElementEventHandler eventHandler() {
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visible(boolean visible) {
        try {
            this.elementLock.readLock().lock();
            super.visible(visible);
            for (Element child : this.elements) {
                ((ElementRich)child).visible(visible);
            }
        }
        finally {
            this.elementLock.readLock().unlock();
        }
    }

    @Override
    public boolean containedWithin(int position) {
        try {
            this.elementLock.readLock().lock();
            if (this.currentLayoutSlot != null) {
                boolean bl = Arrays.stream(this.currentLayoutSlot.slots()).anyMatch(slot -> slot == position);
                return bl;
            }
            boolean bl = this.elements.stream().anyMatch(element -> ((ElementRich)element).containedWithin(position));
            return bl;
        }
        finally {
            this.elementLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersects(@NotNull Element element) {
        try {
            this.elementLock.readLock().lock();
            for (Element child : this.elements) {
                ElementRich e = (ElementRich)child;
                if (e.intersects(element)) {
                    boolean bl = true;
                    return bl;
                }
                if (!(e instanceof ElementItem)) continue;
                int slot = ((ElementItem)e).slot();
                if (this.currentLayoutSlot != null) {
                    boolean bl = Arrays.stream(this.currentLayoutSlot.slots()).anyMatch(s -> s == slot);
                    return bl;
                }
                boolean bl = e.containedWithin(slot);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.elementLock.readLock().unlock();
        }
    }

    @Override
    @NotNull
    public ElementPaginationBuilderRich<T> toBuilder() {
        return new ElementPaginationBuilderImpl(this);
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> update() {
        Preconditions.state((boolean)(this.parent() instanceof ContextRender), (String)"You cannot update the element '%s' when the parent is not a ContextRender!", (Object[])new Object[]{this});
        return this.pipelines.executeUpdate((ContextRender)this.parent(), false);
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> forceUpdate() {
        Preconditions.state((boolean)(this.parent() instanceof ContextRender), (String)"You cannot update the element '%s' when the parent is not a ContextRender!", (Object[])new Object[]{this});
        return this.pipelines.executeUpdate((ContextRender)this.parent(), true);
    }

    @Override
    @NotNull
    public PipelineExecutorElement pipelines() {
        return this.pipelines;
    }

    @NotNull
    public List<Element> elements() {
        try {
            this.elementLock.readLock().lock();
            List<Element> list = Collections.unmodifiableList(this.elements);
            return list;
        }
        finally {
            this.elementLock.readLock().unlock();
        }
    }

    private void addComponentsForUnconstrainedPagination(@NotNull ContextRender context, @NotNull List<T> contents) {
        ViewContainer container = context.container();
        int lastSlot = Math.min(container.lastSlot() + 1, contents.size());
        for (int i = container.firstSlot(); i < lastSlot; ++i) {
            T value = contents.get(i);
            ElementItemBuilder builder = (ElementItemBuilder)new ElementItemBuilderImpl().slot(i).root(this);
            this.elementConfigurer.configure((ContextBase)context, builder, i, i, value);
            this.elements.add((Element)((ElementItemBuilderRich)builder).build((ContextBase)context));
        }
    }

    private void addComponentsForLayeredPagination(@NotNull ContextRender context, @NotNull List<T> contents) {
        LayoutSlot layoutSLot = this.layoutSlotFor(context);
        int elementCount = contents.size();
        int index = 0;
        for (int slot : layoutSLot.slots()) {
            T value = contents.get(index++);
            ElementItemBuilder builder = (ElementItemBuilder)new ElementItemBuilderImpl().slot(slot).root(this);
            this.elementConfigurer.configure((ContextBase)context, builder, index, slot, value);
            this.elements.add((Element)((ElementItemBuilderRich)builder).build((ContextBase)context));
            if (index == elementCount) break;
        }
    }

    @NotNull
    private CompletableFuture<List<T>> loadSourceForTheCurrentPage(@NotNull ContextBase context, boolean forced) {
        boolean reuseLazy;
        boolean isLazy = this.sourceProvider.lazy();
        boolean bl = reuseLazy = isLazy && this.initialized;
        if ((this.sourceProvider.provided() || reuseLazy) && !this.sourceProvider.computed() && !forced) {
            List currentSource = (List)Preconditions.stateNotNull(this.currentSource, (String)"Current source cannot be null in this stage", (Object[])new Object[0]);
            if (!isLazy) {
                this.pageCount = this.calculatePagesCount(currentSource);
            }
            return CompletableFuture.completedFuture(ElementPaginationImpl.splitSourceForPage(this.currentPageIndex, this.pageSize(), this.pageCount, currentSource));
        }
        this.loading = true;
        if (this.sourceFactory == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.sourceFactory.apply(context).thenApply(result -> {
            this.currentSource = result;
            this.pageCount = this.calculatePagesCount((List<T>)result);
            int previousPage = Math.min(this.currentPageIndex, this.pageCount - 1);
            this.loading = false;
            if (previousPage != this.currentPageIndex) {
                this.switchTo(previousPage);
            }
            return isLazy ? ElementPaginationImpl.splitSourceForPage(this.currentPageIndex, this.pageSize(), this.pageCount, result) : result;
        });
    }

    private int calculatePagesCount(@NotNull List<T> source) {
        return (int)Math.ceil((double)source.size() / (double)this.pageSize());
    }

    private int pageSize() {
        Preconditions.state((this.pageSize != -1 ? 1 : 0) != 0, (String)"Page size need to be updated before try to get it", (Object[])new Object[0]);
        return this.pageSize;
    }

    @NotNull
    private LayoutSlot layoutSlotFor(@NotNull ContextRender context) {
        LayoutSlot layoutSlot;
        if (this.currentLayoutSlot != null) {
            return this.currentLayoutSlot;
        }
        this.currentLayoutSlot = layoutSlot = context.layouts().stream().filter(slot -> slot.character() == this.layout).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Layout slot target not found: %c", Character.valueOf(this.layout))));
        return this.currentLayoutSlot;
    }

    @NotNull
    private static <T> List<T> splitSourceForPage(int index, int pageSize, int pagesCount, @NotNull List<T> src) {
        if (src.isEmpty()) {
            return Collections.emptyList();
        }
        if (src.size() <= pageSize) {
            return new ArrayList<T>(src);
        }
        if (index < 0 || pagesCount > 0 && index >= pagesCount) {
            throw new IndexOutOfBoundsException(String.format("Page index must be between the range of 0 and %d. Given: %d", pagesCount - 1, index));
        }
        LinkedList<T> contents = new LinkedList<T>();
        int base = index * pageSize;
        int until = base + pageSize;
        if (until > src.size()) {
            until = src.size();
        }
        for (int i = base; i < until; ++i) {
            contents.add(src.get(i));
        }
        return contents;
    }
}

