/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.view;

import java.lang.reflect.Constructor;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.injection.AnnotationAccessor;
import net.infumia.frame.injection.InjectionRequester;
import net.infumia.frame.injection.InjectionService;
import net.infumia.frame.injection.InjectionServicePipeline;
import net.infumia.frame.injector.InjectionRequest;
import net.infumia.frame.injector.Injector;
import net.infumia.frame.injector.InjectorRegistry;
import net.infumia.frame.util.Preconditions;
import net.infumia.frame.view.ViewCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ViewCreatorImpl
implements ViewCreator {
    private final InjectorRegistry<Object> injectors = InjectorRegistry.create().register((Injector)new NoArg());
    private final InjectionServicePipeline<Object> pipeline = InjectionServicePipeline.create((InjectionService)InjectionService.create(this.injectors));
    private final InjectionRequester<Object> requester = InjectionRequester.create(this.pipeline);

    @NotNull
    public InjectionServicePipeline<Object> pipeline() {
        return this.pipeline;
    }

    @NotNull
    public InjectorRegistry<Object> injectors() {
        return this.injectors;
    }

    @NotNull
    public CompletableFuture<Object> create(@NotNull Class<?> viewClass) {
        return this.requester.request(viewClass, viewClass, AnnotationAccessor.of(viewClass)).handle((value, throwable) -> {
            if (throwable != null) {
                throw new IllegalArgumentException(String.format("Could not create view instance of '%s'.", viewClass), (Throwable)throwable);
            }
            return Preconditions.argumentNotNull((Object)value, (String)"Both error and result is null when requesting an injection for view class '%s'. Please report this bug to the inventory framework you are using.", (Object[])new Object[]{viewClass});
        });
    }

    private static final class NoArg
    implements Injector<Object> {
        private NoArg() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Object inject(@NotNull InjectionRequest<Object> ctx) {
            Class viewClass = ctx.injectedClass();
            Constructor constructor = null;
            boolean old = false;
            try {
                constructor = viewClass.getConstructor(new Class[0]);
                old = constructor.isAccessible();
                Object t = constructor.newInstance(new Object[0]);
                return t;
            }
            catch (Exception exception) {
            }
            finally {
                if (constructor != null) {
                    constructor.setAccessible(old);
                }
            }
            return null;
        }
    }
}

