/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.element.ContextElementClick;
import net.infumia.frame.context.element.ContextElementRender;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.ElementBuilder;
import net.infumia.frame.element.ElementBuilderRich;
import net.infumia.frame.element.ElementImpl;
import net.infumia.frame.element.ElementRich;
import net.infumia.frame.state.State;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementBuilderImpl
implements ElementBuilderRich {
    Element root;
    boolean cancelOnClick;
    boolean closeOnClick;
    boolean updateOnClick;
    Duration interactionDelay;
    Consumer<ContextElementClick> onInteractionDelay;
    Predicate<ContextElementRender> displayIf;
    Collection<State<?>> updateOnStateChange;
    Collection<State<?>> updateOnStateAccess;

    public ElementBuilderImpl(@NotNull Element element) {
        this.root = ((ElementRich)element).root();
        this.cancelOnClick = element.cancelOnClick();
        this.closeOnClick = element.closeOnClick();
        this.updateOnClick = element.updateOnClick();
        this.interactionDelay = element.interactionDelay();
        this.onInteractionDelay = element.onInteractionDelay();
        this.displayIf = element.displayIf();
        this.updateOnStateChange = element.updateOnStateChange();
        this.updateOnStateAccess = element.updateOnStateAccess();
    }

    public ElementBuilderImpl() {
    }

    @Override
    @NotNull
    public ElementBuilder root(@NotNull Element root) {
        this.root = root;
        return this;
    }

    @Override
    @NotNull
    public Element build(@NotNull ContextBase context) {
        return new ElementImpl(this, context);
    }

    @NotNull
    public ElementBuilder cancelOnClick() {
        return this.cancelOnClick(true);
    }

    @NotNull
    public ElementBuilder closeOnClick() {
        return this.closeOnClick(true);
    }

    @NotNull
    public ElementBuilder updateOnClick() {
        return this.updateOnClick(true);
    }

    @NotNull
    public ElementBuilder cancelOnClick(boolean cancelOnClick) {
        this.cancelOnClick = cancelOnClick;
        return this;
    }

    @NotNull
    public ElementBuilder closeOnClick(boolean cancelOnClick) {
        this.closeOnClick = cancelOnClick;
        return this;
    }

    @NotNull
    public ElementBuilder updateOnClick(boolean updateOnClick) {
        this.updateOnClick = updateOnClick;
        return this;
    }

    @NotNull
    public ElementBuilder interactionDelay(@Nullable Duration interactionDelay) {
        this.interactionDelay = interactionDelay;
        return this;
    }

    @NotNull
    public ElementBuilder onInteractionDelay(@NotNull Consumer<ContextElementClick> onInteractionDelay) {
        this.onInteractionDelay = onInteractionDelay;
        return this;
    }

    @NotNull
    public ElementBuilder updateOnStateChange(@NotNull State<?> state, State<?> ... otherStates) {
        if (this.updateOnStateChange == null) {
            this.updateOnStateChange = new HashSet();
        }
        this.updateOnStateChange.add(state);
        Collections.addAll(this.updateOnStateChange, otherStates);
        return this;
    }

    @NotNull
    public ElementBuilder updateOnStateAccess(@NotNull State<?> state, State<?> ... otherStates) {
        if (this.updateOnStateAccess == null) {
            this.updateOnStateAccess = new HashSet();
        }
        this.updateOnStateAccess.add(state);
        Collections.addAll(this.updateOnStateAccess, otherStates);
        return this;
    }

    @NotNull
    public ElementBuilder displayIf(@NotNull Predicate<ContextElementRender> condition) {
        this.displayIf = condition;
        return this;
    }

    @NotNull
    public ElementBuilder displayIf(@NotNull BooleanSupplier condition) {
        return this.displayIf((ContextElementRender __) -> condition.getAsBoolean());
    }

    @NotNull
    public ElementBuilder hideIf(@NotNull Predicate<ContextElementRender> condition) {
        return this.displayIf((ContextElementRender ctx) -> condition.negate().test((ContextElementRender)ctx));
    }

    @NotNull
    public ElementBuilder hideIf(@NotNull BooleanSupplier condition) {
        return this.hideIf((ContextElementRender __) -> condition.getAsBoolean());
    }
}

