/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.infumia.frame.context.Context;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.ContextBaseRich;
import net.infumia.frame.context.ContextImpl;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.state.value.StateValueHost;
import net.infumia.frame.state.value.StateValueHostImpl;
import net.infumia.frame.typedkey.TypedKeyStorageImmutable;
import net.infumia.frame.typedkey.TypedKeyStorageImmutableBuilder;
import net.infumia.frame.util.Preconditions;
import net.infumia.frame.view.View;
import net.infumia.frame.view.config.ViewConfig;
import net.infumia.frame.viewer.Viewer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextBaseImpl
extends ContextImpl
implements ContextBaseRich {
    private final UUID id;
    private final StateValueHost stateValueHost;
    private final View view;
    private final ViewConfig initialConfig;
    private final Collection<Viewer> viewers;
    private final TypedKeyStorageImmutable initialData;
    private final Viewer singleViewer;

    public ContextBaseImpl(@NotNull Context context, @NotNull UUID id, @NotNull View view, @NotNull ViewConfig initialConfig, @NotNull Collection<Viewer> viewers, @NotNull TypedKeyStorageImmutable initialData, @Nullable Viewer singleViewer) {
        super(context);
        this.id = id;
        this.view = view;
        this.initialConfig = initialConfig;
        this.viewers = new HashSet<Viewer>(viewers);
        this.initialData = initialData;
        this.singleViewer = singleViewer;
        this.stateValueHost = new StateValueHostImpl(this);
    }

    public ContextBaseImpl(@NotNull ContextBase context) {
        super((Context)context);
        this.id = context.id();
        this.view = context.view();
        this.initialConfig = context.initialConfig();
        this.viewers = new HashSet<Viewer>(context.viewers());
        this.initialData = context.initialData();
        this.singleViewer = context.viewer();
        this.stateValueHost = context.stateValueHost();
    }

    @NotNull
    public StateValueHost stateValueHost() {
        return this.stateValueHost;
    }

    @NotNull
    public UUID id() {
        return this.id;
    }

    @NotNull
    public View view() {
        return this.view;
    }

    @NotNull
    public ViewConfig initialConfig() {
        return this.initialConfig;
    }

    @NotNull
    public TypedKeyStorageImmutable initialData() {
        return this.initialData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<Viewer> viewers() {
        Collection<Viewer> collection = this.viewers;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.viewers);
        }
    }

    @NotNull
    public Viewer viewer() {
        return this.viewerOrThrow("viewer");
    }

    public boolean sharedView() {
        return this.singleViewer == null || this.viewers().size() > 1;
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> openForEveryone(@NotNull Class<?> viewClass) {
        return this.frame().open((Collection)this.viewers().stream().map(Viewer::player).collect(Collectors.toSet()), viewClass);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> openForEveryone(@NotNull Class<?> viewClass, @NotNull Consumer<TypedKeyStorageImmutableBuilder> initialDataConfigurer) {
        return this.frame().open((Collection)this.viewers().stream().map(Viewer::player).collect(Collectors.toSet()), viewClass, initialDataConfigurer);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> openForViewer(@NotNull Class<?> viewClass) {
        return this.frame().open(this.viewerOrThrow("openForViewer").player(), viewClass);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> openForViewer(@NotNull Class<?> viewClass, @NotNull Consumer<TypedKeyStorageImmutableBuilder> initialData) {
        return this.frame().open(this.viewerOrThrow("openForViewer").player(), viewClass, initialData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addViewer(@NotNull Viewer viewer) {
        Collection<Viewer> collection = this.viewers;
        synchronized (collection) {
            this.viewers.add(viewer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeViewer(@NotNull Viewer viewer) {
        Collection<Viewer> collection = this.viewers;
        synchronized (collection) {
            this.viewers.remove(viewer);
        }
    }

    @Override
    @NotNull
    public Viewer viewerOrThrow(@NotNull String methodName) {
        Preconditions.state((!this.sharedView() ? 1 : 0) != 0, (String)"You cannot use #%s() method if it's a shared view!", (Object[])new Object[]{methodName});
        return (Viewer)Preconditions.argumentNotNull((Object)this.singleViewer, (String)"Viewer not set even tough it's not a shared view!", (Object[])new Object[0]);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextBase)) {
            return false;
        }
        return Objects.equals(this.id, ((ContextBase)o).id());
    }
}

