/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline;

import io.leangen.geantyref.TypeToken;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.pipeline.PipelineConsumer;
import net.infumia.frame.pipeline.PipelineContext;
import net.infumia.frame.pipeline.PipelineServiceConsumer;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.service.ServicePipelineBuilder;
import net.infumia.frame.service.ServiceRepository;
import org.jetbrains.annotations.NotNull;

public final class PipelineConsumerImpl<B extends PipelineContext>
implements PipelineConsumer<B> {
    private final ServiceRepository<B, ConsumerService.State> repository;

    private PipelineConsumerImpl(@NotNull ServiceRepository<B, ConsumerService.State> repository) {
        this.repository = repository;
    }

    public PipelineConsumerImpl(@NotNull TypeToken<PipelineServiceConsumer<B>> type, @NotNull PipelineServiceConsumer<B> defaultService) {
        this(ServicePipelineBuilder.newBuilder().build().create(type, defaultService));
    }

    @NotNull
    public PipelineConsumer<B> apply(@NotNull Implementation<B, ConsumerService.State> operation) {
        this.repository.apply(operation);
        return this;
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> completeWith(@NotNull B context) {
        return this.repository.completeWith(context);
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> completeWithAsync(@NotNull B context) {
        return this.repository.completeWithAsync(context);
    }

    @NotNull
    public PipelineConsumer<B> cloned() {
        return new PipelineConsumerImpl<B>(this.repository.cloned());
    }
}

