/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.view;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.infumia.frame.config.ViewConfigRich;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.view.ContextInit;
import net.infumia.frame.context.view.ContextOpen;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.context.view.ContextRenderRich;
import net.infumia.frame.metadata.MetadataKeyHolder;
import net.infumia.frame.pipeline.context.PipelineContextView;
import net.infumia.frame.pipeline.executor.PipelineExecutorView;
import net.infumia.frame.pipeline.executor.PipelineExecutorViewImpl;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.slot.LayoutSlot;
import net.infumia.frame.typedkey.TypedKeyStorageImmutable;
import net.infumia.frame.util.Pair;
import net.infumia.frame.view.View;
import net.infumia.frame.view.ViewContainer;
import net.infumia.frame.view.ViewEventHandler;
import net.infumia.frame.view.config.ViewConfig;
import net.infumia.frame.view.config.option.ViewConfigOptions;
import net.infumia.frame.viewer.ContextualViewer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ViewImpl
implements View,
ViewEventHandler {
    private final PipelineExecutorView pipelines = new PipelineExecutorViewImpl(this);
    private final Object instance;
    private final ContextInit context;

    public ViewImpl(@NotNull ContextInit context, @NotNull Object instance) {
        this.context = context;
        this.instance = instance;
    }

    @NotNull
    public ContextInit context() {
        return this.context;
    }

    @NotNull
    public Object instance() {
        return this.instance;
    }

    @NotNull
    public PipelineExecutorView pipelines() {
        return this.pipelines;
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> simulateOnInit() {
        return this.pipelines.executeInit(this.context);
    }

    @Override
    public @NotNull CompletableFuture<@Nullable ContextRender> simulateOpen(@NotNull Collection<Player> viewers, @NotNull TypedKeyStorageImmutable initialData) {
        return ((CompletableFuture)this.pipelines.executeCreateViewers(viewers).thenCompose(v -> this.pipelines.executeCreateContext(v, initialData))).thenCompose(this::navigate);
    }

    @Override
    public @NotNull CompletableFuture<@Nullable ContextRender> simulateOpenActive(@NotNull ContextRender activeContext, @NotNull Collection<Player> viewers) {
        return ((CompletableFuture)this.pipelines.executeCreateViewers(viewers).thenCompose(((ContextRenderRich)activeContext)::simulateNavigate)).thenApply(__ -> activeContext);
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> simulateClick(@NotNull ContextualViewer viewer, @NotNull InventoryClickEvent event) {
        return this.pipelines.executeClick(viewer, event);
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> simulateClose(@NotNull ContextualViewer viewer) {
        ContextualViewer transitioning = (ContextualViewer)viewer.metadata().remove(MetadataKeyHolder.TRANSITIONING_FROM);
        Boolean forcedClose = (Boolean)viewer.metadata().remove(MetadataKeyHolder.FORCED_CLOSE);
        boolean forced = transitioning != null || forcedClose != null && forcedClose != false;
        return this.pipelines.executeClose(viewer, forced);
    }

    @Override
    public void handleItemPickup(@NotNull ContextualViewer viewer, @NotNull PlayerPickupItemEvent event) {
        ContextRender context = viewer.context();
        ViewConfigRich config = (ViewConfigRich)context.config();
        config.option(ViewConfigOptions.CANCEL_ON_PICKUP).filter(l -> l).ifPresent(cancel -> event.setCancelled(true));
    }

    @Override
    public void handleItemDrop(@NotNull ContextualViewer viewer, @NotNull PlayerDropItemEvent event) {
        ContextRender context = viewer.context();
        ViewConfigRich config = (ViewConfigRich)context.config();
        config.option(ViewConfigOptions.CANCEL_ON_DROP).filter(l -> l).ifPresent(cancel -> event.setCancelled(true));
    }

    @Override
    public void handleInventoryDrag(@NotNull ContextualViewer viewer, @NotNull InventoryDragEvent event) {
        ContextRender context = viewer.context();
        ViewConfigRich config = (ViewConfigRich)context.config();
        config.option(ViewConfigOptions.CANCEL_ON_DRAG).filter(l -> l).ifPresent(cancel -> event.setCancelled(true));
    }

    private @NotNull CompletionStage<@Nullable ContextRender> navigate(@NotNull ContextBase context) {
        return ((CompletableFuture)this.pipelines.executeOpen(context).thenApply(Pair::second)).thenCompose(open -> {
            if (open.cancelled()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.executeProcessConfigModifiers((ContextOpen)open);
        });
    }

    @NotNull
    private CompletableFuture<ContextRender> executeProcessConfigModifiers(@NotNull ContextOpen context) {
        return this.pipelines.executeProcessConfigModifiers(context).thenCompose(__ -> this.executeCreateContainer((ContextBase)context, context.buildFinalConfig()));
    }

    @NotNull
    private CompletableFuture<ContextRender> executeCreateContainer(@NotNull ContextBase context, @NotNull ViewConfig config) {
        return this.pipelines.executeCreateContainer(context, config).thenCompose(container -> this.executeModifyContainer(context, config, (ViewContainer)container));
    }

    @NotNull
    private CompletableFuture<ContextRender> executeModifyContainer(@NotNull ContextBase context, @NotNull ViewConfig config, @NotNull ViewContainer container) {
        return this.pipelines.executeModifyContainer(context, config, container).thenCompose(pair -> this.executeLayoutResolution(context, config, ((PipelineContextView.ModifyContainer)pair.second()).container()));
    }

    @NotNull
    private CompletableFuture<ContextRender> executeLayoutResolution(@NotNull ContextBase context, @NotNull ViewConfig config, @NotNull ViewContainer container) {
        return this.pipelines.executeLayoutResolution(context, config, container).thenCompose(pair -> this.executeCreateRender(context, config, container, (Collection)pair.second()));
    }

    @NotNull
    private CompletableFuture<ContextRender> executeCreateRender(@NotNull ContextBase context, @NotNull ViewConfig config, @NotNull ViewContainer container, @NotNull Collection<LayoutSlot> layouts) {
        return this.pipelines.executeCreateRender(context, config, container, layouts).thenCompose(render -> ((ContextRenderRich)render).simulateFirstRender().thenApply(__ -> render));
    }
}

