/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.state.value;

import net.infumia.frame.context.ContextBase;
import net.infumia.frame.state.value.StateValue;
import net.infumia.frame.state.value.StateValueComputed;
import net.infumia.frame.typedkey.TypedKeyStorageImmutable;
import net.infumia.frame.util.Lazy;
import net.infumia.frame.util.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StateValueInitial<T>
implements StateValue<T> {
    private final String stateKey;
    private final ContextBase context;
    private StateValue<T> backingValue;

    public StateValueInitial(@NotNull ContextBase context, @NotNull String stateKey) {
        this.stateKey = stateKey;
        this.context = context;
        this.backingValue = this.createBackingValue(stateKey);
    }

    @Nullable
    public T value() {
        return (T)this.backingValue.value();
    }

    public void value(@Nullable T value) {
        this.backingValue.value(value);
    }

    public boolean mutable() {
        return this.backingValue.mutable();
    }

    public void reset() {
        this.backingValue = this.createBackingValue(this.stateKey);
    }

    private StateValue<T> createBackingValue(@NotNull String key) {
        return new StateValueComputed(Lazy.of(() -> {
            TypedKeyStorageImmutable initialData = (TypedKeyStorageImmutable)Preconditions.stateNotNull((Object)this.context.initialData(), (String)"Initial data not found even tough there is a initial state '%s' registered!", (Object[])new Object[]{key});
            Object value = Preconditions.stateNotNull((Object)initialData.get(key), (String)"No initial data found for state '%s'", (Object[])new Object[]{key});
            try {
                return value;
            }
            catch (ClassCastException e) {
                throw new RuntimeException(String.format("Invalid data type '%s' for state '%s'!", value.getClass().getSimpleName(), key), e);
            }
        }));
    }
}

