/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.state.value;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.extension.CompletableFutureExtensions;
import net.infumia.frame.pipeline.PipelineServiceConsumer;
import net.infumia.frame.pipeline.context.PipelineContextState;
import net.infumia.frame.pipeline.executor.PipelineExecutorState;
import net.infumia.frame.pipeline.executor.PipelineExecutorStateImpl;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.service.Service;
import net.infumia.frame.state.State;
import net.infumia.frame.state.StateMutableRich;
import net.infumia.frame.state.StateRich;
import net.infumia.frame.state.value.StateUpdate;
import net.infumia.frame.state.value.StateValue;
import net.infumia.frame.state.value.StateValueHostRich;
import net.infumia.frame.state.watcher.StateWatcherAccess;
import net.infumia.frame.state.watcher.StateWatcherUpdate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StateValueHostImpl
implements StateValueHostRich {
    private final Map<StateRich<Object>, StateValue<Object>> values = new HashMap<StateRich<Object>, StateValue<Object>>();
    private final ContextBase context;
    private final PipelineExecutorState pipelines;

    public StateValueHostImpl(@NotNull ContextBase context) {
        this.context = context;
        this.pipelines = new PipelineExecutorStateImpl(context);
    }

    @Override
    @NotNull
    public Map<StateRich<Object>, StateValue<Object>> stateValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    @NotNull
    public <T> StateValue<T> accessStateValueOrInitialize(@NotNull StateRich<T> state) {
        return this.accessStateValueOrInitializeInternally(state, this.accessStateValue(state));
    }

    @Override
    @Nullable
    public <T> StateValue<T> accessStateValue(@NotNull StateRich<T> state) {
        StateValue<Object> value = this.values.get(state);
        if (value == null) {
            this.context.frame().logger().debug("State '%s' not found in '%s'!", new Object[]{state, this.values});
            return null;
        }
        CompletableFutureExtensions.logError(this.pipelines.executeAccess(state, value), this.context.frame().logger(), "An error occurred while accessing state '%s'!", state);
        return value;
    }

    @Override
    @Nullable
    public <T> StateValue<T> updateStateValue(@NotNull StateMutableRich<T> state, @Nullable T value) {
        StateValue<T> stateValue = this.accessStateValue(state);
        if (stateValue == null) {
            return null;
        }
        Object oldValue = stateValue.value();
        stateValue.value(value);
        CompletableFutureExtensions.logError(this.pipelines.executeUpdate(state, oldValue, stateValue), this.context.frame().logger(), "An error occurred while updating state '%s'!", state);
        return stateValue;
    }

    @Override
    @Nullable
    public <T> StateValue<T> updateStateValue(@NotNull StateRich<T> state) {
        StateValue<T> stateValue = this.accessStateValue(state);
        if (stateValue == null) {
            return null;
        }
        CompletableFutureExtensions.logError(this.pipelines.executeUpdate(state, stateValue.value(), stateValue), this.context.frame().logger(), "An error occurred while updating state '%s'!", state);
        return stateValue;
    }

    @Override
    @NotNull
    public <T> CompletableFuture<StateValue<T>> accessStateValueOrInitializeWait(@NotNull StateRich<T> state) {
        return this.accessStateValueWait(state).thenApply(value -> this.accessStateValueOrInitializeInternally(state, (StateValue)value));
    }

    @Override
    public <T> @NotNull CompletableFuture<@Nullable StateValue<T>> accessStateValueWait(@NotNull StateRich<T> state) {
        StateValue<Object> value = this.values.get(state);
        if (value == null) {
            this.context.frame().logger().debug("State '%s' not found in '%s'!", new Object[]{state, this.values});
            return CompletableFuture.completedFuture(null);
        }
        return this.pipelines.executeAccess(state, value).thenApply(__ -> value);
    }

    @Override
    public <T> @NotNull CompletableFuture<@Nullable StateValue<T>> updateStateValueWait(@NotNull StateMutableRich<T> state, @Nullable T value) {
        return this.accessStateValueWait(state).thenCompose(stateValue -> {
            if (stateValue == null) {
                return CompletableFuture.completedFuture(null);
            }
            Object oldValue = stateValue.value();
            stateValue.value(value);
            return this.pipelines.executeUpdate((State)state, oldValue, stateValue).thenApply(__ -> stateValue);
        });
    }

    @Override
    public <T> @NotNull CompletableFuture<@Nullable StateValue<T>> updateStateValueWait(@NotNull StateRich<T> state) {
        return this.accessStateValueWait(state).thenCompose(stateValue -> {
            if (stateValue == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.pipelines.executeUpdate((State)state, stateValue.value(), stateValue).thenApply(__ -> stateValue);
        });
    }

    @Override
    public <T> void watchStateAccess(final @NotNull StateRich<T> state, final @NotNull StateWatcherAccess<T> watcher) {
        this.pipelines.applyAccess(Implementation.register((Service)new PipelineServiceConsumer<PipelineContextState.Access>(){

            @NotNull
            public String key() {
                return "";
            }

            public void accept(@NotNull PipelineContextState.Access ctx) {
                if (((StateRich)ctx.state()).id() == state.id()) {
                    watcher.access(ctx.value());
                }
            }
        }));
    }

    @Override
    public <T> void watchStateUpdate(final @NotNull StateRich<T> state, final @NotNull StateWatcherUpdate<T> watcher) {
        this.pipelines.applyUpdate(Implementation.register((Service)new PipelineServiceConsumer<PipelineContextState.Update>(){

            @NotNull
            public String key() {
                return "";
            }

            public void accept(@NotNull PipelineContextState.Update ctx) {
                if (((StateRich)ctx.state()).id() == state.id()) {
                    watcher.update(new StateUpdate((State)state, ctx.oldValue(), ctx.value()));
                }
            }
        }));
    }

    @Override
    public <T> void initializeState(@NotNull StateRich<T> state, @NotNull StateValue<T> value) {
        this.values.put(state, value);
        this.context.frame().logger().debug("State '%s' initialized with value '%s'", new Object[]{state, value});
    }

    @NotNull
    private <T> StateValue<T> accessStateValueOrInitializeInternally(@NotNull StateRich<T> state, @Nullable StateValue<T> value) {
        if (value != null) {
            return value;
        }
        StateValue stateValue = (StateValue)state.valueFactory().apply(this.context, state);
        this.initializeState(state, stateValue);
        return stateValue;
    }
}

