/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.state;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.state.StateRich;
import net.infumia.frame.state.value.StateValue;
import net.infumia.frame.state.value.StateValueFactory;
import net.infumia.frame.state.value.StateValueHostHolder;
import net.infumia.frame.state.value.StateValueHostRich;
import net.infumia.frame.state.watcher.StateWatcherAccess;
import net.infumia.frame.state.watcher.StateWatcherUpdate;
import net.infumia.frame.util.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateImpl<T>
implements StateRich<T> {
    private final long id;
    private final StateValueFactory<T> valueFactory;

    public StateImpl(long id, @NotNull StateValueFactory<T> valueFactory) {
        this.id = id;
        this.valueFactory = valueFactory;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    @NotNull
    public StateValueFactory<T> valueFactory() {
        return this.valueFactory;
    }

    @Override
    @Nullable
    public StateValue<T> manualUpdate(@NotNull StateValueHostHolder host) {
        return ((StateValueHostRich)host.stateValueHost()).updateStateValue(this);
    }

    @Override
    @NotNull
    public CompletableFuture<StateValue<T>> manualUpdateWait(@NotNull StateValueHostHolder host) {
        return ((StateValueHostRich)host.stateValueHost()).updateStateValueWait(this);
    }

    @Nullable
    public T get(@NotNull StateValueHostHolder host) {
        return (T)((StateValueHostRich)host.stateValueHost()).accessStateValueOrInitialize(this).value();
    }

    @NotNull
    public T getOtThrow(@NotNull StateValueHostHolder host) {
        return (T)Preconditions.stateNotNull(this.get(host), (String)"Value for state '%s' not found!", (Object[])new Object[]{this.id});
    }

    public @NotNull CompletableFuture<@Nullable T> getWait(@NotNull StateValueHostHolder host) {
        return ((StateValueHostRich)host.stateValueHost()).accessStateValueOrInitializeWait(this).thenApply(StateValue::value);
    }

    @NotNull
    public CompletableFuture<T> getOtThrowWait(@NotNull StateValueHostHolder host) {
        return this.getWait(host).thenApply(value -> Preconditions.stateNotNull((Object)value, (String)"Value for state '%s' not found!", (Object[])new Object[]{this.id}));
    }

    public void watchAccess(@NotNull StateValueHostHolder host, @NotNull StateWatcherAccess<T> watcher) {
        ((StateValueHostRich)host.stateValueHost()).watchStateAccess(this, watcher);
    }

    public void watchUpdate(@NotNull StateValueHostHolder host, @NotNull StateWatcherUpdate<T> watcher) {
        ((StateValueHostRich)host.stateValueHost()).watchStateUpdate(this, watcher);
    }

    public String toString() {
        return new StringJoiner(", ", StateImpl.class.getSimpleName() + "[", "]").add("id=" + this.id).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateRich)) {
            return false;
        }
        return this.id == ((StateRich)o).id();
    }
}

