/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.listener;

import java.util.function.Consumer;
import net.infumia.frame.extension.CompletableFutureExtensions;
import net.infumia.frame.logger.Logger;
import net.infumia.frame.metadata.MetadataAccessFactory;
import net.infumia.frame.metadata.MetadataKeyHolder;
import net.infumia.frame.view.ViewEventHandler;
import net.infumia.frame.viewer.ContextualViewer;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class InventoryListener
implements Listener {
    private final Plugin plugin;
    private final Logger logger;
    private final MetadataAccessFactory metadataAccessFactory;
    private final Runnable onUnregister;

    public InventoryListener(@NotNull Plugin plugin, @NotNull Logger logger, @NotNull MetadataAccessFactory metadataAccessFactory, @NotNull Runnable onUnregister) {
        this.plugin = plugin;
        this.logger = logger;
        this.metadataAccessFactory = metadataAccessFactory;
        this.onUnregister = onUnregister;
    }

    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().getName().equals(this.plugin.getName())) {
            this.onUnregister.run();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        this.ifContextualViewer((Metadatable)event.getWhoClicked(), viewer -> CompletableFutureExtensions.logError(((ViewEventHandler)viewer.view()).simulateClick((ContextualViewer)viewer, event), this.logger, "Error occurred while viewer '%s' clicks an inventory!", viewer));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        this.transitioningOrCurrent((Metadatable)event.getPlayer(), viewer -> CompletableFutureExtensions.logError(((ViewEventHandler)viewer.view()).simulateClose((ContextualViewer)viewer), this.logger, "Error occurred while viewer '%s' closes an inventory", viewer));
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemPickup(PlayerPickupItemEvent event) {
        this.ifContextualViewer((Metadatable)event.getPlayer(), viewer -> ((ViewEventHandler)viewer.view()).handleItemPickup((ContextualViewer)viewer, event));
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent event) {
        this.ifContextualViewer((Metadatable)event.getPlayer(), viewer -> ((ViewEventHandler)viewer.view()).handleItemDrop((ContextualViewer)viewer, event));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        this.ifContextualViewer((Metadatable)event.getWhoClicked(), viewer -> ((ViewEventHandler)viewer.view()).handleInventoryDrag((ContextualViewer)viewer, event));
    }

    private void ifContextualViewer(@NotNull Metadatable metadatable, @NotNull Consumer<ContextualViewer> consumer) {
        ContextualViewer viewer = (ContextualViewer)this.metadataAccessFactory.getOrCreate(metadatable).get(MetadataKeyHolder.CONTEXTUAL_VIEWER);
        if (viewer != null) {
            consumer.accept(viewer);
        }
    }

    private void transitioningOrCurrent(@NotNull Metadatable metadatable, @NotNull Consumer<ContextualViewer> consumer) {
        ContextualViewer transitioningFrom = (ContextualViewer)this.metadataAccessFactory.getOrCreate(metadatable).get(MetadataKeyHolder.TRANSITIONING_FROM);
        if (transitioningFrom == null) {
            this.ifContextualViewer(metadatable, consumer);
        } else {
            consumer.accept(transitioningFrom);
        }
    }
}

