/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element.pagination;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.infumia.frame.context.ContextBase;
import org.jetbrains.annotations.NotNull;

public interface SourceProvider<T>
extends Function<ContextBase, CompletableFuture<List<T>>> {
    public boolean lazy();

    public boolean computed();

    public boolean provided();

    public static final class Computed<T>
    implements SourceProvider<T> {
        private final Function<ContextBase, CompletableFuture<List<T>>> provider;
        private final boolean computed;
        private final boolean lazy;

        public Computed(@NotNull Function<ContextBase, CompletableFuture<List<T>>> provider, boolean computed, boolean lazy) {
            this.provider = provider;
            this.computed = computed;
            this.lazy = lazy;
        }

        public Computed(@NotNull Supplier<CompletableFuture<List<T>>> provider, boolean computed, boolean lazy) {
            this((ContextBase base) -> (CompletableFuture)provider.get(), computed, lazy);
        }

        @Override
        public boolean lazy() {
            return this.lazy;
        }

        @Override
        public boolean computed() {
            return this.computed;
        }

        @Override
        public boolean provided() {
            return false;
        }

        @Override
        @NotNull
        public CompletableFuture<List<T>> apply(@NotNull ContextBase context) {
            return this.provider.apply(context);
        }
    }

    public static final class Immutable<T>
    implements SourceProvider<T> {
        private final List<T> values;

        public Immutable(@NotNull List<T> values) {
            this.values = values;
        }

        @Override
        @NotNull
        public CompletableFuture<List<T>> apply(@NotNull ContextBase context) {
            return CompletableFuture.completedFuture(this.values);
        }

        @Override
        public boolean lazy() {
            return false;
        }

        @Override
        public boolean computed() {
            return false;
        }

        @Override
        public boolean provided() {
            return true;
        }
    }
}

