/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.infumia.frame.Frame;
import net.infumia.frame.FrameRich;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.extension.CompletableFutureExtensions;
import net.infumia.frame.listener.InventoryListener;
import net.infumia.frame.logger.Logger;
import net.infumia.frame.metadata.MetadataAccessFactory;
import net.infumia.frame.metadata.MetadataAccessFactoryImpl;
import net.infumia.frame.pipeline.executor.PipelineExecutorFrame;
import net.infumia.frame.pipeline.executor.PipelineExecutorFrameImpl;
import net.infumia.frame.task.TaskFactory;
import net.infumia.frame.task.TaskFactoryImpl;
import net.infumia.frame.typedkey.TypedKeyStorageFactory;
import net.infumia.frame.typedkey.TypedKeyStorageImmutableBuilder;
import net.infumia.frame.util.Preconditions;
import net.infumia.frame.view.View;
import net.infumia.frame.view.ViewCreator;
import net.infumia.frame.view.ViewCreatorImpl;
import net.infumia.frame.view.ViewEventHandler;
import net.infumia.frame.view.creator.InventoryCreator;
import net.infumia.frame.view.creator.InventoryCreatorBukkit;
import net.infumia.frame.viewer.ViewerCreator;
import net.infumia.frame.viewer.ViewerCreatorImpl;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FrameImpl
implements FrameRich {
    private final Collection<Class<?>> unregisteredViews = ConcurrentHashMap.newKeySet();
    private final Map<Class<?>, View> registeredViews = new ConcurrentHashMap();
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final PipelineExecutorFrame pipelines = new PipelineExecutorFrameImpl(this);
    private final ViewCreator viewCreator = new ViewCreatorImpl();
    private final Logger logger;
    private final TaskFactory taskFactory;
    private final InventoryListener listener;
    private final MetadataAccessFactory metadataAccessFactory;
    private final ViewerCreator viewerCreator;
    private TypedKeyStorageFactory storageFactory = TypedKeyStorageFactory.create();
    private InventoryCreator inventoryCreator = InventoryCreatorBukkit.bukkitOrPaper();

    FrameImpl(@NotNull Plugin plugin, @NotNull Logger logger, boolean unregisterOnDisable) {
        this.logger = logger;
        this.taskFactory = new TaskFactoryImpl(plugin, logger);
        this.metadataAccessFactory = new MetadataAccessFactoryImpl(plugin);
        this.listener = new InventoryListener(plugin, logger, this.metadataAccessFactory, () -> {
            if (unregisterOnDisable) {
                this.unregister();
            }
        });
        this.viewerCreator = new ViewerCreatorImpl(this.metadataAccessFactory);
    }

    @Override
    @NotNull
    public InventoryListener listener() {
        return this.listener;
    }

    @NotNull
    public Logger logger() {
        return this.logger;
    }

    @NotNull
    public TaskFactory taskFactory() {
        return this.taskFactory;
    }

    @NotNull
    public ViewCreator viewCreator() {
        return this.viewCreator;
    }

    @NotNull
    public ViewerCreator viewerCreator() {
        return this.viewerCreator;
    }

    @NotNull
    public TypedKeyStorageFactory storageFactory() {
        return this.storageFactory;
    }

    public void storageFactory(@NotNull TypedKeyStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    @NotNull
    public InventoryCreator inventoryCreator() {
        return this.inventoryCreator;
    }

    public void inventoryCreator(@NotNull InventoryCreator inventoryCreator) {
        this.inventoryCreator = inventoryCreator;
    }

    public void register() {
        this.register(builder -> {});
    }

    public void register(@NotNull Consumer<TypedKeyStorageImmutableBuilder> instanceConfigurer) {
        Preconditions.state((!this.registered.get() ? 1 : 0) != 0, (String)"This frame is already registered! #register() method cannot be called twice!", (Object[])new Object[0]);
        this.registered.set(true);
        ((CompletableFuture)this.executeViewCreation(this.unregisteredViews, instanceConfigurer).thenCompose(views -> {
            this.registeredViews.clear();
            this.registeredViews.putAll(views.stream().collect(Collectors.toMap(view -> view.instance().getClass(), Function.identity())));
            return this.pipelines.executeListenersRegistered();
        })).exceptionally(throwable -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (throwable != null) {
                this.logger.error(throwable, "Error occurred while registering views!", new Object[0]);
                this.unregisterInternally();
            }
            return null;
        });
    }

    public void unregister() {
        this.unregisterInternally();
    }

    @NotNull
    public Frame with(@NotNull Class<?> viewClass) {
        Preconditions.argument((!this.registered.get() ? 1 : 0) != 0, (String)"This frame is registered!", (Object[])new Object[0]);
        this.intoUnregisteredViews(viewClass);
        return this;
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> open(@NotNull Player player, @NotNull Class<?> viewClass) {
        return this.open(Collections.singleton(player), viewClass);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> open(@NotNull Player player, @NotNull Class<?> viewClass, @NotNull Consumer<TypedKeyStorageImmutableBuilder> initialDataConfigurer) {
        return this.open(Collections.singleton(player), viewClass, initialDataConfigurer);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> open(@NotNull Collection<Player> players, @NotNull Class<?> viewClass) {
        return this.open(players, viewClass, (TypedKeyStorageImmutableBuilder builder) -> {});
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> open(@NotNull Collection<Player> players, @NotNull Class<?> viewClass, @NotNull Consumer<TypedKeyStorageImmutableBuilder> initialDataConfigurer) {
        View view = this.findView(viewClass);
        if (!(view instanceof ViewEventHandler)) {
            return CompletableFuture.completedFuture(null);
        }
        TypedKeyStorageImmutableBuilder builder = this.storageFactory.createImmutableBuilder(new HashMap());
        initialDataConfigurer.accept(builder);
        return CompletableFutureExtensions.logError(((ViewEventHandler)view).simulateOpen(players, builder.build()), this.logger, "Error occurred while opening view '%s'!", viewClass);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> openActive(@NotNull Player player, @NotNull ContextRender activeContext) {
        return this.openActive(Collections.singleton(player), activeContext);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> openActive(@NotNull Collection<Player> players, @NotNull ContextRender activeContext) {
        View view = activeContext.view();
        if (!(view instanceof ViewEventHandler)) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFutureExtensions.logError(((ViewEventHandler)view).simulateOpenActive(activeContext, players), this.logger, "Error occurred while opening an active view '%s'!", view.instance());
    }

    @NotNull
    public PipelineExecutorFrame pipelines() {
        return this.pipelines;
    }

    @NotNull
    private View findView(@NotNull Class<?> viewClass) {
        Preconditions.state((boolean)this.registered.get(), (String)"Before you open a view you must register this frame!", (Object[])new Object[0]);
        return (View)Preconditions.argumentNotNull((Object)this.registeredViews.get(viewClass), (String)"View '%s' is not registered!", (Object[])new Object[]{viewClass});
    }

    private void intoUnregisteredViews(@NotNull Class<?> viewClass) {
        Preconditions.argument((!this.unregisteredViews.contains(viewClass) ? 1 : 0) != 0, (String)"View class '%s' already registered.", (Object[])new Object[]{viewClass});
        this.logger.debug("View class '%s' recognized.", new Object[]{viewClass});
        this.unregisteredViews.add(viewClass);
    }

    @NotNull
    private CompletableFuture<Collection<View>> executeViewCreation(@NotNull Collection<Class<?>> views, @NotNull Consumer<TypedKeyStorageImmutableBuilder> instanceConfigurer) {
        return this.pipelines.executeViewCreated(views).thenCompose(instances -> this.pipelines.executeViewRegistered(instances, instanceConfigurer));
    }

    private void unregisterInternally() {
        this.registered.set(false);
        this.metadataAccessFactory.clearCache(Bukkit.getOnlinePlayers());
        HandlerList.unregisterAll((Listener)this.listener);
        HashMap views = new HashMap(this.registeredViews);
        this.registeredViews.clear();
        this.executeViewUnRegistration(views);
    }

    private void executeViewUnRegistration(@NotNull Map<Class<?>, View> views) {
        this.pipelines.executeViewUnregistered(views.values()).whenComplete((state, throwable) -> {
            if (throwable != null) {
                this.logger.error(throwable, "Error occurred while unregistering views '%s'!", new Object[]{views.keySet()});
            }
        });
    }
}

