/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.viewer;

import java.util.Objects;
import net.infumia.frame.metadata.MetadataAccess;
import net.infumia.frame.view.View;
import net.infumia.frame.view.ViewContainer;
import net.infumia.frame.viewer.Viewer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ViewerImpl
implements Viewer {
    private final Player player;
    private final View view;
    private final MetadataAccess metadata;

    public ViewerImpl(@NotNull Player player, @NotNull View view, @NotNull MetadataAccess metadata) {
        this.player = player;
        this.view = view;
        this.metadata = metadata;
    }

    public ViewerImpl(@NotNull Viewer viewer) {
        this(viewer.player(), viewer.view(), viewer.metadata());
    }

    @NotNull
    public View view() {
        return this.view;
    }

    @NotNull
    public Player player() {
        return this.player;
    }

    public void close() {
        if (this.player.isOnline()) {
            this.player.closeInventory();
        }
    }

    public void open(@NotNull ViewContainer container) {
        if (this.player.isOnline()) {
            this.player.openInventory(container.inventory());
        }
    }

    @NotNull
    public MetadataAccess metadata() {
        return this.metadata;
    }

    public int hashCode() {
        return this.player.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Player) {
            return this.player.equals(o);
        }
        return Objects.equals(this.player, ((Viewer)o).player());
    }
}

