/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.infumia.frame.Frame;
import net.infumia.frame.pipeline.PipelineContext;
import net.infumia.frame.pipeline.context.PipelineContextFrame;
import net.infumia.frame.pipeline.context.PipelineContextFrames;
import net.infumia.frame.pipeline.executor.PipelineExecutorFrame;
import net.infumia.frame.pipeline.holder.PipelineHolderFrame;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.typedkey.TypedKeyStorageImmutableBuilder;
import net.infumia.frame.view.View;
import org.jetbrains.annotations.NotNull;

public final class PipelineExecutorFrameImpl
implements PipelineExecutorFrame {
    private final PipelineHolderFrame pipelines = PipelineHolderFrame.BASE.cloned();
    private final Frame frame;

    public PipelineExecutorFrameImpl(@NotNull Frame frame) {
        this.frame = frame;
    }

    @NotNull
    public CompletableFuture<Collection<Object>> executeViewCreated(@NotNull Collection<Class<?>> registeredViews) {
        return this.pipelines.viewCreated().completeWith((PipelineContext)new PipelineContextFrames.ViewCreated(this.frame, Collections.unmodifiableCollection(registeredViews)));
    }

    @NotNull
    public CompletableFuture<Collection<View>> executeViewRegistered(@NotNull Collection<Object> registeredViews, @NotNull Consumer<TypedKeyStorageImmutableBuilder> instanceConfigurer) {
        return this.pipelines.viewRegistered().completeWith((PipelineContext)new PipelineContextFrames.ViewRegistered(this.frame, Collections.unmodifiableCollection(registeredViews), instanceConfigurer));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeListenersRegistered() {
        return this.pipelines.listenersRegistered().completeWith((PipelineContext)new PipelineContextFrames.ListenerRegistered(this.frame));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeViewUnregistered(@NotNull Collection<View> unregisteredViews) {
        return this.pipelines.viewUnregistered().completeWith((PipelineContext)new PipelineContextFrames.ViewUnregistered(this.frame, Collections.unmodifiableCollection(unregisteredViews)));
    }

    public void applyViewCreated(@NotNull Implementation<PipelineContextFrame.ViewCreated, Collection<Object>> implementation) {
        this.pipelines.viewCreated().apply(implementation);
    }

    public void applyViewRegistered(@NotNull Implementation<PipelineContextFrame.ViewRegistered, Collection<View>> implementation) {
        this.pipelines.viewRegistered().apply(implementation);
    }

    public void applyListenersRegistered(@NotNull Implementation<PipelineContextFrame.ListenerRegistered, ConsumerService.State> implementation) {
        this.pipelines.listenersRegistered().apply(implementation);
    }

    public void applyViewUnregistered(@NotNull Implementation<PipelineContextFrame.ViewUnregistered, ConsumerService.State> implementation) {
        this.pipelines.viewUnregistered().apply(implementation);
    }
}

