/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.extension;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.infumia.frame.logger.Logger;
import org.jetbrains.annotations.NotNull;

public final class CompletableFutureExtensions {
    @NotNull
    public static <T> CompletableFuture<T> logError(@NotNull CompletableFuture<T> future, @NotNull Logger logger, @NotNull String message, Object ... args) {
        return future.exceptionally(throwable -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof StackOverflowError) {
                throwable.printStackTrace();
            } else {
                logger.error(throwable, message, args);
            }
            return null;
        });
    }
}

