/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.context.view;

import net.infumia.frame.context.view.ContextClick;
import net.infumia.frame.context.view.ContextRenderImpl;
import net.infumia.frame.view.ViewContainer;
import net.infumia.frame.viewer.ContextualViewer;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextClickImpl
extends ContextRenderImpl
implements ContextClick {
    private final ContextualViewer clicker;
    private final InventoryClickEvent event;

    public ContextClickImpl(@NotNull ContextualViewer clicker, @NotNull InventoryClickEvent event) {
        super(clicker.context());
        this.clicker = clicker;
        this.event = event;
    }

    public ContextClickImpl(@NotNull ContextClick context) {
        this(context.clicker(), context.event());
    }

    @NotNull
    public InventoryClickEvent event() {
        return this.event;
    }

    @NotNull
    public ContextualViewer clicker() {
        return this.clicker;
    }

    @NotNull
    public ClickType clickType() {
        return this.event.getClick();
    }

    @Nullable
    public ViewContainer clickedContainer() {
        return this.container().at(this.clickedSlot());
    }

    public int clickedSlot() {
        return this.event.getSlot();
    }

    public int clickedSlotRaw() {
        return this.event.getRawSlot();
    }

    @NotNull
    public InventoryType.SlotType clickedSlotType() {
        return this.event.getSlotType();
    }

    public boolean leftClick() {
        return this.event.isLeftClick();
    }

    public boolean rightClick() {
        return this.event.isRightClick();
    }

    public boolean middleClick() {
        return this.clickType() == ClickType.MIDDLE;
    }

    public boolean shiftClick() {
        return this.event.isShiftClick();
    }

    public boolean keyboardClick() {
        return this.clickType().isKeyboardClick();
    }

    public boolean outsideClicked() {
        return this.clickedSlotType() == InventoryType.SlotType.OUTSIDE;
    }

    public boolean entityContainer() {
        return this.event.getClickedInventory() instanceof PlayerInventory;
    }

    public boolean isLayoutSlot() {
        return this.layouts().stream().anyMatch(slot -> slot.contains(this.clickedSlot()));
    }

    public boolean isLayoutSlot(char character) {
        return this.layouts().stream().filter(slot -> slot.character() == character).findFirst().map(slot -> slot.contains(this.clickedSlotRaw())).orElse(false);
    }

    public boolean cancelled() {
        return this.event.isCancelled();
    }

    public void cancelled(boolean cancelled) {
        this.event.setCancelled(cancelled);
    }
}

