/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.view;

import java.util.concurrent.CompletableFuture;
import net.infumia.frame.Preconditions;
import net.infumia.frame.injector.AnnotationAccessor;
import net.infumia.frame.injector.InjectionRequester;
import net.infumia.frame.injector.InjectionService;
import net.infumia.frame.injector.InjectionServicePipeline;
import net.infumia.frame.injector.InjectorNoArg;
import net.infumia.frame.injector.InjectorRegistry;
import net.infumia.frame.injector.InjectorStaticInstance;
import net.infumia.frame.view.ViewFactory;
import org.jetbrains.annotations.NotNull;

public final class ViewFactoryImpl
implements ViewFactory {
    private final InjectorRegistry<Object> injectors = InjectorRegistry.create().register(InjectorNoArg.INSTANCE).register(InjectorStaticInstance.INSTANCE);
    private final InjectionServicePipeline<Object> pipeline = InjectionServicePipeline.create((InjectionService)InjectionService.create(this.injectors));
    private final InjectionRequester<Object> requester = InjectionRequester.create(this.pipeline);

    @NotNull
    public InjectionServicePipeline<Object> pipelines() {
        return this.pipeline;
    }

    @NotNull
    public InjectorRegistry<Object> injectors() {
        return this.injectors;
    }

    @NotNull
    public CompletableFuture<Object> create(@NotNull Class<?> viewClass) {
        return this.requester.request(viewClass, viewClass, AnnotationAccessor.of(viewClass)).handle((value, throwable) -> {
            if (throwable != null) {
                throw new IllegalArgumentException(String.format("Could not create view instance of '%s'.", viewClass), (Throwable)throwable);
            }
            return Preconditions.argumentNotNull((Object)value, (String)"Both error and result is null when requesting an injection for view class '%s'. Please report this bug to the inventory framework you are using.", (Object[])new Object[]{viewClass});
        });
    }
}

