/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.view;

import net.infumia.frame.InvTypeRich;
import net.infumia.frame.InvTypes;
import net.infumia.frame.type.InvType;
import net.infumia.frame.view.InventoryHolderFrame;
import net.infumia.frame.view.ViewContainer;
import net.infumia.frame.view.ViewContainerRich;
import net.infumia.frame.viewer.Viewer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ViewContainerImpl
implements ViewContainerRich {
    private final InventoryHolderFrame inventoryHolder;
    private final InvTypeRich type;

    public ViewContainerImpl(@NotNull InventoryHolderFrame inventoryHolder, @NotNull InvTypeRich type) {
        this.inventoryHolder = inventoryHolder;
        this.type = type;
    }

    @Override
    @NotNull
    public InventoryHolderFrame inventoryHolder() {
        return this.inventoryHolder;
    }

    @NotNull
    public InvType type() {
        return this.type.type();
    }

    public int size() {
        return this.inventoryHolder.getInventory().getSize();
    }

    public int slotsCount() {
        return this.size() - 1;
    }

    public int rowsCount() {
        return this.size() / this.columnsCount();
    }

    public int columnsCount() {
        return this.type.columns();
    }

    public int firstSlot() {
        return this.type == InvTypes.PLAYER ? 45 : 0;
    }

    public int lastSlot() {
        int[] resultSlots;
        int lastSlot = this.slotsCount();
        for (int resultSlot : resultSlots = this.type.resultSlots()) {
            if (resultSlot != lastSlot) continue;
            --lastSlot;
        }
        return lastSlot;
    }

    public boolean hasItem(int slot) {
        return this.inventoryHolder.getInventory().getItem(slot) != null;
    }

    public void removeItem(int slot) {
        this.inventoryHolder.getInventory().setItem(slot, null);
    }

    public void addItem(int slot, @NotNull ItemStack item) {
        this.inventoryHolder.getInventory().setItem(slot, item);
    }

    public void open(@NotNull Viewer viewer) {
        viewer.open((ViewContainer)this);
    }

    public boolean isPlayerInventory() {
        return this.inventoryHolder.getInventory() instanceof PlayerInventory;
    }

    @Nullable
    public ViewContainer at(int slot) {
        return slot >= this.firstSlot() && slot <= this.lastSlot() ? this : null;
    }

    @Override
    @NotNull
    public InvTypeRich typeRich() {
        return this.type;
    }
}

