/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.infumia.frame.logger.Logger;
import net.infumia.frame.state.StateRich;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StateRegistry
implements Iterable<StateRich<Object>> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Long, StateRich<Object>> states = new HashMap<Long, StateRich<Object>>();
    private final Logger logger;

    public StateRegistry(@NotNull Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public StateRich<?> byId(long internalId) {
        try {
            this.lock.readLock().lock();
            StateRich<Object> stateRich = this.states.get(internalId);
            return stateRich;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void register(@NotNull StateRich<?> state) {
        try {
            this.lock.writeLock().lock();
            this.states.put(state.id(), state);
            this.logger.debug("State '%s:%s' registered", new Object[]{state.id(), state});
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void unregister(@NotNull StateRich<?> state) {
        try {
            this.lock.writeLock().lock();
            this.states.remove(state.id());
            this.logger.debug("State '%s:%s' unregistered", new Object[]{state.id(), state});
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    @NotNull
    public Iterator<StateRich<Object>> iterator() {
        try {
            this.lock.readLock().lock();
            Iterator<StateRich<Object>> iterator = Collections.unmodifiableCollection(this.states.values()).iterator();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

