/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.slot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.infumia.frame.InvTypeRich;
import net.infumia.frame.Preconditions;
import net.infumia.frame.SlotConverter;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.element.item.ElementItemBuilder;
import net.infumia.frame.element.item.ElementItemBuilderRich;
import net.infumia.frame.slot.LayoutSlot;
import net.infumia.frame.view.ViewContainerRich;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SlotFinder {
    private final List<BiFunction<Integer, Integer, ElementItemBuilder>> availableSlotFinders = new ArrayList<BiFunction<Integer, Integer, ElementItemBuilder>>();
    private final Collection<ElementItemBuilderRich> nonRenderedBuilders = new ArrayList<ElementItemBuilderRich>();
    private final ContextRender context;

    public SlotFinder(@NotNull ContextRender context) {
        this.context = context;
    }

    @Nullable
    public LayoutSlot findLayoutSlot(char character) {
        return this.context.layouts().stream().filter(slot -> slot.character() == character).findFirst().orElse(null);
    }

    public int findFirstSlot() {
        return this.context.container().firstSlot();
    }

    public int findLastSlot() {
        return this.context.container().lastSlot();
    }

    public int findResultSlot() {
        InvTypeRich type = ((ViewContainerRich)this.context.container()).typeRich();
        int[] slots = type.resultSlots();
        Preconditions.state((slots.length != 0 ? 1 : 0) != 0, (String)"No result slot available for type '%s'", (Object[])new Object[]{type.type()});
        Preconditions.state((slots.length == 1 ? 1 : 0) != 0, (String)"Multiple result slots not supported right now!", (Object[])new Object[0]);
        return slots[0];
    }

    public int toSlot(int row, int column) {
        return SlotConverter.convertSlot(row, column, this.context.container().rowsCount(), this.context.container().columnsCount());
    }

    @NotNull
    public List<BiFunction<Integer, Integer, ElementItemBuilder>> availableSlotFinders() {
        return Collections.unmodifiableList(this.availableSlotFinders);
    }

    @NotNull
    public Collection<ElementItemBuilderRich> nonRenderedBuilders() {
        return this.nonRenderedBuilders;
    }

    public void addAvailableSlotFinder(@NotNull BiFunction<Integer, Integer, ElementItemBuilder> indexAndSlotToBuilder) {
        this.availableSlotFinders.add(indexAndSlotToBuilder);
    }

    public void addNonRenderedBuilder(@NotNull ElementItemBuilderRich builder) {
        this.nonRenderedBuilders.add(builder);
    }
}

