/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.service.view;

import java.time.Duration;
import java.util.HashMap;
import java.util.function.Consumer;
import net.infumia.frame.context.view.ContextClick;
import net.infumia.frame.metadata.MetadataAccess;
import net.infumia.frame.metadata.MetadataKeyHolder;
import net.infumia.frame.pipeline.PipelineServiceConsumer;
import net.infumia.frame.pipeline.context.PipelineContextView;
import net.infumia.frame.view.config.ViewConfig;
import net.infumia.frame.viewer.Viewer;
import org.jetbrains.annotations.NotNull;

public final class ServiceClickInteractionDelay
implements PipelineServiceConsumer<PipelineContextView.Click> {
    public static final PipelineServiceConsumer<PipelineContextView.Click> INSTANCE = new ServiceClickInteractionDelay();
    public static final String KEY = "interaction-delay";

    @NotNull
    public String key() {
        return KEY;
    }

    public void accept(@NotNull PipelineContextView.Click ctx) {
        ContextClick context = ctx.context();
        ViewConfig config = context.config();
        Duration delay = config.interactionDelay();
        if (delay == null || delay.isZero() || delay.isNegative()) {
            return;
        }
        Viewer clicker = context.clicker();
        MetadataAccess metadata = clicker.metadata();
        HashMap<String, Long> lastInteractions = (HashMap<String, Long>)metadata.get(MetadataKeyHolder.LAST_INTERACTION);
        if (lastInteractions == null) {
            lastInteractions = new HashMap<String, Long>();
            metadata.setFixed(MetadataKeyHolder.LAST_INTERACTION, lastInteractions);
        }
        String key = context.id().toString();
        Long lastInteraction = (Long)lastInteractions.get(key);
        long now = System.currentTimeMillis();
        if (lastInteraction == null) {
            lastInteractions.put(key, now);
            return;
        }
        long elapsed = now - lastInteraction;
        if (elapsed > delay.toMillis()) {
            lastInteractions.put(key, now);
        } else {
            context.frame().logger().debug("Click event of viewer '%s' cancelled due to interaction delay.", new Object[]{clicker});
            ctx.cancelled(true);
            context.cancelled(true);
            Consumer onInteractionDelay = config.onInteractionDelay();
            if (onInteractionDelay != null) {
                onInteractionDelay.accept(context);
            }
        }
    }

    private ServiceClickInteractionDelay() {
    }
}

