/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.service.render;

import java.util.Collection;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.ElementContainer;
import net.infumia.frame.element.ElementRich;
import net.infumia.frame.pipeline.PipelineServiceConsumer;
import net.infumia.frame.pipeline.context.PipelineContextRender;
import net.infumia.frame.state.State;
import net.infumia.frame.state.value.StateValueHostHolder;
import org.jetbrains.annotations.NotNull;

public final class ServiceFirstRenderWatchState
implements PipelineServiceConsumer<PipelineContextRender.FirstRender> {
    public static final PipelineServiceConsumer<PipelineContextRender.FirstRender> INSTANCE = new ServiceFirstRenderWatchState();
    public static final String KEY = "watch-state";

    @NotNull
    public String key() {
        return KEY;
    }

    public void accept(@NotNull PipelineContextRender.FirstRender ctx) {
        ContextRender context = ctx.context();
        for (Element element : ctx.elements()) {
            ServiceFirstRenderWatchState.watch(context, (ElementRich)element);
        }
    }

    private static void watch(@NotNull ContextRender context, @NotNull ElementRich element) {
        ServiceFirstRenderWatchState.updateOnStateAccess(context, element);
        ServiceFirstRenderWatchState.updateOnStateChange(context, element);
        if (element instanceof ElementContainer) {
            for (Element child : ((ElementContainer)element).elements()) {
                ServiceFirstRenderWatchState.watch(context, (ElementRich)child);
            }
        }
    }

    private static void updateOnStateAccess(@NotNull ContextRender context, @NotNull ElementRich element) {
        Collection states = element.updateOnStateAccess();
        if (states == null) {
            return;
        }
        for (State state : states) {
            state.watchAccess((StateValueHostHolder)context, update -> context.frame().loggedFuture(element.update(), "An error occurred while updating element '%s' due to state '%s' access!", new Object[]{element.key(), state}));
        }
    }

    private static void updateOnStateChange(@NotNull ContextRender context, @NotNull ElementRich element) {
        Collection states = element.updateOnStateChange();
        if (states == null) {
            return;
        }
        for (State state : states) {
            state.watchUpdate((StateValueHostHolder)context, update -> context.frame().loggedFuture(element.update(), "An error occurred while updating element '%s' due to state '%s' change!", new Object[]{element.key(), state}));
        }
    }

    private ServiceFirstRenderWatchState() {
    }
}

