/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline;

import io.leangen.geantyref.TypeToken;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.pipeline.PipelineConsumer;
import net.infumia.frame.pipeline.PipelineServiceConsumer;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.service.ServicePipelineBuilder;
import net.infumia.frame.service.ServiceRepository;
import org.jetbrains.annotations.NotNull;

public final class PipelineConsumerImpl<Context>
implements PipelineConsumer<Context> {
    private final ServiceRepository<Context, ConsumerService.State> repository;

    private PipelineConsumerImpl(@NotNull ServiceRepository<Context, ConsumerService.State> repository) {
        this.repository = repository;
    }

    public PipelineConsumerImpl(@NotNull TypeToken<PipelineServiceConsumer<Context>> type, @NotNull PipelineServiceConsumer<Context> defaultService) {
        this(ServicePipelineBuilder.newBuilder().build().create(type, defaultService));
    }

    @NotNull
    public PipelineConsumer<Context> apply(@NotNull Implementation<Context, ConsumerService.State> operation) {
        this.repository.apply(operation);
        return this;
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> completeWith(@NotNull Context context) {
        return this.repository.completeDirect(context);
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> completeWithAsync(@NotNull Context context) {
        return this.repository.completeAsync(context);
    }

    @NotNull
    public PipelineConsumer<Context> cloned() {
        return new PipelineConsumerImpl<Context>(this.repository.cloned());
    }
}

