/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.metadata;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.infumia.frame.Preconditions;
import net.infumia.frame.metadata.MetadataAccess;
import net.infumia.frame.typedkey.TypedKey;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetadataAccessImpl
implements MetadataAccess {
    private final Collection<TypedKey<?>> registered = ConcurrentHashMap.newKeySet();
    private final Plugin plugin;
    private final Metadatable metadatable;

    public MetadataAccessImpl(@NotNull Plugin plugin, @NotNull Metadatable metadatable) {
        this.plugin = plugin;
        this.metadatable = metadatable;
    }

    @Nullable
    public <T> T get(@NotNull TypedKey<T> key) {
        return this.metadatable.getMetadata(key.key()).stream().filter(metadataValue -> Objects.equals(metadataValue.getOwningPlugin(), this.plugin)).findFirst().map(metadataValue -> metadataValue.value()).orElse(null);
    }

    @NotNull
    public <T> T getOrThrow(@NotNull TypedKey<T> key) {
        return (T)Preconditions.argumentNotNull(this.get(key), (String)("Metadata value for key " + key + " not found!"), (Object[])new Object[0]);
    }

    public <T> T getOrDefault(@NotNull TypedKey<T> key, @Nullable T defaultValue) {
        T value = this.get(key);
        return value == null ? defaultValue : value;
    }

    @Nullable
    public <T> T remove(@NotNull TypedKey<T> key) {
        T data = this.get(key);
        this.registered.remove(key);
        this.metadatable.removeMetadata(key.key(), this.plugin);
        return data;
    }

    public boolean has(@NotNull TypedKey<?> key) {
        return this.metadatable.hasMetadata(key.key());
    }

    public <T> void setFixed(@NotNull TypedKey<T> key, @NotNull T value) {
        this.registered.add(key);
        this.metadatable.setMetadata(key.key(), (MetadataValue)new FixedMetadataValue(this.plugin, value));
    }

    public <T> void setLazy(@NotNull TypedKey<T> key, @NotNull Callable<T> value, @NotNull LazyMetadataValue.CacheStrategy cacheStrategy) {
        this.registered.add(key);
        this.metadatable.setMetadata(key.key(), (MetadataValue)new LazyMetadataValue(this.plugin, cacheStrategy, value::call));
    }

    public <T> void setLazy(@NotNull TypedKey<T> key, @NotNull Callable<T> value) {
        this.setLazy(key, value, LazyMetadataValue.CacheStrategy.CACHE_AFTER_FIRST_EVAL);
    }

    public void removeAll() {
        for (TypedKey<?> key : this.registered) {
            this.metadatable.removeMetadata(key.key(), this.plugin);
        }
        this.registered.clear();
    }
}

