/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.logger;

import java.util.logging.Level;
import net.infumia.frame.logger.Logger;
import net.infumia.frame.util.PaperLib;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PluginLogger
implements Logger {
    @NotNull
    private final Plugin plugin;
    private boolean debug = false;

    public PluginLogger(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    public synchronized boolean isDebugEnabled() {
        return this.debug;
    }

    public synchronized void enableDebug(boolean enable) {
        this.debug = enable;
    }

    public void error(@NotNull Throwable throwable, @NotNull String message, Object ... args) {
        String formatted = String.format(message, args);
        if (PaperLib.isPaper()) {
            this.plugin.getSLF4JLogger().error(formatted, throwable);
        } else {
            this.plugin.getLogger().log(Level.SEVERE, formatted, throwable);
        }
    }

    public void error(@NotNull String message, Object ... args) {
        String formatted = String.format(message, args);
        if (PaperLib.isPaper()) {
            this.plugin.getSLF4JLogger().error(formatted);
        } else {
            this.plugin.getLogger().severe(formatted);
        }
    }

    public void warn(@NotNull String message, Object ... args) {
        String formatted = String.format(message, args);
        if (PaperLib.isPaper()) {
            this.plugin.getSLF4JLogger().warn(formatted);
        } else {
            this.plugin.getLogger().warning(formatted);
        }
    }

    public void info(@NotNull String message, Object ... args) {
        String formatted = String.format(message, args);
        if (PaperLib.isPaper()) {
            this.plugin.getSLF4JLogger().info(formatted);
        } else {
            this.plugin.getLogger().info(formatted);
        }
    }

    public void debug(@NotNull String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.info(message, args);
        }
    }
}

