/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.context.view;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.infumia.frame.Preconditions;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.ContextBaseImpl;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.context.view.ContextRenderRich;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.item.ElementItemBuilder;
import net.infumia.frame.element.item.ElementItemBuilderImpl;
import net.infumia.frame.element.item.ElementItemBuilderRich;
import net.infumia.frame.metadata.MetadataAccess;
import net.infumia.frame.metadata.MetadataKeyHolder;
import net.infumia.frame.pipeline.executor.PipelinesRender;
import net.infumia.frame.pipeline.executor.PipelinesRenderImpl;
import net.infumia.frame.pipeline.executor.PipelinesViewer;
import net.infumia.frame.pipeline.executor.PipelinesViewerImpl;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.slot.LayoutSlot;
import net.infumia.frame.slot.SlotFinder;
import net.infumia.frame.view.ViewContainer;
import net.infumia.frame.view.config.ViewConfig;
import net.infumia.frame.viewer.Viewer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextRenderImpl
extends ContextBaseImpl
implements ContextRenderRich {
    private final PipelinesRender pipelines;
    private final PipelinesViewer pipelinesViewer;
    private final SlotFinder slotFinder;
    private final List<Element> elements;
    private final ViewContainer container;
    private final ViewConfig config;
    private final Collection<LayoutSlot> layouts;
    private Closeable updateTask;

    public ContextRenderImpl(@NotNull ContextBase context, @NotNull ViewContainer container, @NotNull ViewConfig config, @NotNull Collection<LayoutSlot> layouts) {
        super(context);
        this.container = container;
        this.config = config;
        this.layouts = new ArrayList<LayoutSlot>(layouts);
        this.slotFinder = new SlotFinder(this);
        this.elements = new ArrayList<Element>();
        this.pipelines = new PipelinesRenderImpl(this);
        this.pipelinesViewer = new PipelinesViewerImpl(this);
    }

    public ContextRenderImpl(@NotNull ContextRender context) {
        super((ContextBase)context);
        this.container = context.container();
        this.config = context.config();
        this.layouts = new ArrayList<LayoutSlot>(context.layouts());
        this.slotFinder = ((ContextRenderRich)context).slotFinder();
        this.elements = new ArrayList<Element>(context.elements());
        this.pipelines = (PipelinesRender)context.pipelines();
        this.pipelinesViewer = context.pipelinesViewer();
        this.updateTask = ((ContextRenderRich)context).updateTask();
    }

    @NotNull
    public ViewContainer container() {
        return this.container;
    }

    @NotNull
    public ViewConfig config() {
        return this.config;
    }

    @NotNull
    public Collection<LayoutSlot> layouts() {
        return Collections.unmodifiableCollection(this.layouts);
    }

    public void back() {
        Viewer viewer = this.viewerOrThrow("back");
        MetadataAccess metadata = viewer.metadata();
        Deque previousContexts = (Deque)metadata.get(MetadataKeyHolder.PREVIOUS_VIEWS);
        if (previousContexts == null) {
            return;
        }
        ContextRender previousContext = (ContextRender)previousContexts.pollLast();
        if (previousContext == null) {
            metadata.remove(MetadataKeyHolder.PREVIOUS_VIEWS);
            return;
        }
        if (previousContexts.isEmpty()) {
            metadata.remove(MetadataKeyHolder.PREVIOUS_VIEWS);
        }
        this.frame().openActive(viewer.player(), previousContext).thenCompose(__ -> ((ContextRenderRich)previousContext).simulateResume(this, Collections.singleton(viewer)));
    }

    public boolean canBack() {
        Deque previousViews = (Deque)this.viewerOrThrow("canBack").metadata().get(MetadataKeyHolder.PREVIOUS_VIEWS);
        return previousViews != null && !previousViews.isEmpty();
    }

    public void closeForEveryone() {
        this.closeForEveryone(true);
    }

    public void closeForViewer() {
        this.closeForViewer(true);
    }

    public void closeForEveryone(boolean forced) {
        for (Viewer viewer : this.viewers()) {
            viewer.metadata().setFixed(MetadataKeyHolder.FORCED_CLOSE, (Object)true);
            viewer.close();
        }
    }

    public void closeForViewer(boolean forced) {
        Preconditions.state((!this.sharedView() ? 1 : 0) != 0, (String)"You cannot use #closeForViewer() method if it's a shared view!", (Object[])new Object[0]);
        Viewer viewer = this.viewer();
        if (forced) {
            viewer.metadata().setFixed(MetadataKeyHolder.FORCED_CLOSE, (Object)true);
        }
        viewer.close();
    }

    @NotNull
    public PipelinesViewer pipelinesViewer() {
        return this.pipelinesViewer;
    }

    @Override
    @NotNull
    public SlotFinder slotFinder() {
        return this.slotFinder;
    }

    @Override
    public void updateTask(@Nullable Closeable task) {
        this.updateTask = task;
    }

    @Override
    @Nullable
    public Closeable updateTask() {
        return this.updateTask;
    }

    @Override
    public void addElement(@NotNull Element element) {
        this.elements.add(element);
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> simulateFirstRender() {
        return this.pipelines.executeFirstRender().thenCompose(__ -> this.simulateNavigate(this.viewers()));
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> simulateNavigate(@NotNull Collection<Viewer> viewers) {
        return ((CompletableFuture)((CompletableFuture)this.pipelines.executeStartTransition(viewers).thenCompose(__ -> this.pipelinesViewer.executeAdded(viewers))).thenCompose(__ -> this.pipelines.executeOpenContainer(viewers))).thenCompose(__ -> this.pipelines.executeStartUpdate());
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> simulateResume(@NotNull ContextRender from, @NotNull Collection<Viewer> viewers) {
        return this.pipelines.executeResume(from, viewers);
    }

    @NotNull
    public PipelinesRender pipelines() {
        return this.pipelines;
    }

    @NotNull
    public List<Element> elements() {
        return Collections.unmodifiableList(this.elements);
    }

    @NotNull
    public ElementItemBuilder unsetSlot() {
        return this.newRegisteredBuilder();
    }

    @NotNull
    public ElementItemBuilder layoutSlot(char layout) {
        LayoutSlot layoutSlot = (LayoutSlot)Preconditions.argumentNotNull((Object)this.slotFinder.findLayoutSlot(layout), (String)"Missing layout character '%s'", (Object[])new Object[]{Character.valueOf(layout)});
        ElementItemBuilderRich builder = this.newUnregisteredBuilder();
        this.layouts.add(layoutSlot.withBuilderFactory(value -> builder));
        return builder;
    }

    @NotNull
    public ElementItemBuilder layoutSlot(char layout, @NotNull ItemStack item) {
        return this.layoutSlot(layout).item(item);
    }

    public void layoutSlot(char layout, @NotNull BiConsumer<Integer, ElementItemBuilder> configurer) {
        LayoutSlot layoutSlot = (LayoutSlot)Preconditions.argumentNotNull((Object)this.slotFinder.findLayoutSlot(layout), (String)"Missing layout character '%s'", (Object[])new Object[]{Character.valueOf(layout)});
        this.layouts.add(layoutSlot.withBuilderFactory(index -> {
            ElementItemBuilderRich builder = this.newUnregisteredBuilder();
            configurer.accept(index, builder);
            return builder;
        }));
    }

    @NotNull
    public ElementItemBuilder slot(int slot) {
        return this.unsetSlot().slot(slot);
    }

    @NotNull
    public ElementItemBuilder position(int row, int column) {
        return this.slot(this.slotFinder.toSlot(row, column));
    }

    @NotNull
    public ElementItemBuilder firstSlot() {
        return this.slot(this.slotFinder.findFirstSlot());
    }

    @NotNull
    public ElementItemBuilder lastSlot() {
        return this.slot(this.slotFinder.findLastSlot());
    }

    public void availableSlot(@NotNull ItemStack item) {
        this.availableSlot((Integer __, ElementItemBuilder builder) -> builder.item(item));
    }

    public void availableSlot(@NotNull BiConsumer<Integer, ElementItemBuilder> configurer) {
        this.slotFinder.addAvailableSlotFinder((index, slot) -> {
            ElementItemBuilder builder = this.newUnregisteredBuilder().slot((int)slot);
            configurer.accept((Integer)index, builder);
            return builder;
        });
    }

    @NotNull
    public ElementItemBuilder resultSlot() {
        return this.slot(this.slotFinder.findResultSlot());
    }

    @NotNull
    public ElementItemBuilder resultSlot(@NotNull ItemStack item) {
        return this.resultSlot().item(item);
    }

    @NotNull
    private ElementItemBuilderRich newUnregisteredBuilder() {
        return new ElementItemBuilderImpl();
    }

    @NotNull
    private ElementItemBuilderRich newRegisteredBuilder() {
        ElementItemBuilderRich builder = this.newUnregisteredBuilder();
        this.slotFinder.addNonRenderedBuilder(builder);
        return builder;
    }
}

