/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.executor;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.Pair;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.view.ContextClickImpl;
import net.infumia.frame.context.view.ContextCloseImpl;
import net.infumia.frame.context.view.ContextInit;
import net.infumia.frame.context.view.ContextOpen;
import net.infumia.frame.context.view.ContextOpenImpl;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.pipeline.context.PipelineContextView;
import net.infumia.frame.pipeline.context.PipelineContextViews;
import net.infumia.frame.pipeline.executor.PipelinesView;
import net.infumia.frame.pipeline.holder.PipelineHolderView;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.slot.LayoutSlot;
import net.infumia.frame.typedkey.TypedKeyStorageImmutable;
import net.infumia.frame.view.View;
import net.infumia.frame.view.ViewContainer;
import net.infumia.frame.view.config.ViewConfig;
import net.infumia.frame.viewer.Viewer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public final class PipelinesViewImpl
implements PipelinesView {
    private final PipelineHolderView pipelines = PipelineHolderView.BASE.cloned();
    private final View view;

    public PipelinesViewImpl(@NotNull View view) {
        this.view = view;
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeInit(@NotNull ContextInit context) {
        return this.pipelines.init().completeWith((Object)new PipelineContextViews.Init(this.view));
    }

    @NotNull
    public CompletableFuture<Collection<Viewer>> executeCreateViewers(@NotNull Collection<Player> viewers) {
        return this.pipelines.createViewers().completeWith((Object)new PipelineContextViews.CreateViewers(this.view, viewers));
    }

    @NotNull
    public CompletableFuture<ContextBase> executeCreateContext(@NotNull Collection<Viewer> viewers, @NotNull TypedKeyStorageImmutable initialData) {
        return this.pipelines.createContext().completeWith((Object)new PipelineContextViews.CreateContext(this.view, viewers, initialData));
    }

    @NotNull
    public CompletableFuture<Pair<ConsumerService.State, ContextOpen>> executeOpen(@NotNull ContextBase context) {
        ContextOpenImpl open = new ContextOpenImpl(context);
        return this.pipelines.open().completeWith((Object)new PipelineContextViews.Open(open)).thenApply(state -> Pair.of((Object)state, (Object)open));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeProcessConfigModifiers(@NotNull ContextOpen context) {
        return this.pipelines.processConfigModifiers().completeWith((Object)new PipelineContextViews.ProcessConfigModifier(context));
    }

    @NotNull
    public CompletableFuture<ViewContainer> executeCreateContainer(@NotNull ContextBase context, @NotNull ViewConfig config) {
        return this.pipelines.createContainer().completeWith((Object)new PipelineContextViews.CreateContainer(context, config));
    }

    @NotNull
    public CompletableFuture<ViewContainer> executeModifyContainer(@NotNull ContextBase context, @NotNull ViewConfig config, @NotNull ViewContainer container) {
        PipelineContextViews.ModifyContainer ctx = new PipelineContextViews.ModifyContainer(context, config, container);
        return this.pipelines.modifyContainer().completeWith((Object)ctx).thenApply(__ -> ctx.container());
    }

    @NotNull
    public CompletableFuture<Collection<LayoutSlot>> executeLayoutResolution(@NotNull ContextBase context, @NotNull ViewConfig config, @NotNull ViewContainer container) {
        PipelineContextViews.LayoutResolution layoutResolution = new PipelineContextViews.LayoutResolution(context, config, container);
        return this.pipelines.layoutResolution().completeWith((Object)layoutResolution).thenApply(__ -> layoutResolution.layouts());
    }

    @NotNull
    public CompletableFuture<ContextRender> executeCreateRender(@NotNull ContextBase context, @NotNull ViewConfig config, @NotNull ViewContainer container, @NotNull Collection<LayoutSlot> layouts) {
        return this.pipelines.createRender().completeWith((Object)new PipelineContextViews.CreateRender(context, config, container, layouts));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeClick(@NotNull ContextRender ctx, @NotNull Viewer clicker, @NotNull InventoryClickEvent event) {
        return this.pipelines.click().completeWith((Object)new PipelineContextViews.Click(new ContextClickImpl(ctx, clicker, event)));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeClose(@NotNull ContextRender ctx, @NotNull Viewer viewer, boolean forced) {
        return this.pipelines.close().completeWith((Object)new PipelineContextViews.Close(new ContextCloseImpl(ctx, viewer, forced)));
    }

    public void applyInit(@NotNull Implementation<PipelineContextView.Init, ConsumerService.State> implementation) {
        this.pipelines.init().apply(implementation);
    }

    public void applyCreateViewers(@NotNull Implementation<PipelineContextView.CreateViewers, Collection<Viewer>> implementation) {
        this.pipelines.createViewers().apply(implementation);
    }

    public void applyCreateContext(@NotNull Implementation<PipelineContextView.CreateContext, ContextBase> implementation) {
        this.pipelines.createContext().apply(implementation);
    }

    public void applyOpen(@NotNull Implementation<PipelineContextView.Open, ConsumerService.State> implementation) {
        this.pipelines.open().apply(implementation);
    }

    public void applyProcessConfigModifiers(@NotNull Implementation<PipelineContextView.ProcessConfigModifier, ConsumerService.State> implementation) {
        this.pipelines.processConfigModifiers().apply(implementation);
    }

    public void applyCreateContainer(@NotNull Implementation<PipelineContextView.CreateContainer, ViewContainer> implementation) {
        this.pipelines.createContainer().apply(implementation);
    }

    public void applyModifyContainer(@NotNull Implementation<PipelineContextView.ModifyContainer, ConsumerService.State> implementation) {
        this.pipelines.modifyContainer().apply(implementation);
    }

    public void applyLayoutResolution(@NotNull Implementation<PipelineContextView.LayoutResolution, ConsumerService.State> implementation) {
        this.pipelines.layoutResolution().apply(implementation);
    }

    public void applyCreateRender(@NotNull Implementation<PipelineContextView.CreateRender, ContextRender> implementation) {
        this.pipelines.createRender().apply(implementation);
    }

    public void applyClick(@NotNull Implementation<PipelineContextView.Click, ConsumerService.State> implementation) {
        this.pipelines.click().apply(implementation);
    }

    public void applyClose(@NotNull Implementation<PipelineContextView.Close, ConsumerService.State> implementation) {
        this.pipelines.close().apply(implementation);
    }
}

