/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.executor;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.context.view.ContextResumeImpl;
import net.infumia.frame.pipeline.context.PipelineContextRender;
import net.infumia.frame.pipeline.context.PipelineContextRenders;
import net.infumia.frame.pipeline.context.PipelineContextView;
import net.infumia.frame.pipeline.context.PipelineContextViews;
import net.infumia.frame.pipeline.executor.PipelinesRender;
import net.infumia.frame.pipeline.holder.PipelineHolderRender;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.viewer.Viewer;
import org.jetbrains.annotations.NotNull;

public final class PipelinesRenderImpl
implements PipelinesRender {
    private final PipelineHolderRender pipelines = PipelineHolderRender.BASE.cloned();
    private final ContextRender context;

    public PipelinesRenderImpl(@NotNull ContextRender context) {
        this.context = context;
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeFirstRender() {
        return this.pipelines.firstRender().completeWith((Object)new PipelineContextRenders.FirstRender(this.context));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeStartTransition(@NotNull Collection<Viewer> viewers) {
        return this.pipelines.startTransition().completeWith((Object)new PipelineContextViews.StartTransition((ContextBase)this.context, viewers));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeOpenContainer(@NotNull Collection<Viewer> viewers) {
        return this.pipelines.openContainer().completeWith((Object)new PipelineContextRenders.OpenContainer(this.context, viewers));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeStartUpdate() {
        return this.pipelines.startUpdate().completeWith((Object)new PipelineContextRenders.StartUpdate(this.context));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeResume(@NotNull ContextRender from, @NotNull Collection<Viewer> viewers) {
        return this.pipelines.resume().completeWith((Object)new PipelineContextRenders.Resume(new ContextResumeImpl(this.context, from, viewers)));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeStopUpdate() {
        return this.pipelines.stopUpdate().completeWith((Object)new PipelineContextRenders.StopUpdate(this.context));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeUpdate() {
        return this.pipelines.update().completeWith((Object)new PipelineContextRenders.Update(this.context));
    }

    public void applyFirstRender(@NotNull Implementation<PipelineContextRender.FirstRender, ConsumerService.State> implementation) {
        this.pipelines.firstRender().apply(implementation);
    }

    public void applyStartTransition(@NotNull Implementation<PipelineContextView.StartTransition, ConsumerService.State> implementation) {
        this.pipelines.startTransition().apply(implementation);
    }

    public void applyOpenContainer(@NotNull Implementation<PipelineContextRender.OpenContainer, ConsumerService.State> implementation) {
        this.pipelines.openContainer().apply(implementation);
    }

    public void applyStartUpdate(@NotNull Implementation<PipelineContextRender.StartUpdate, ConsumerService.State> implementation) {
        this.pipelines.startUpdate().apply(implementation);
    }

    public void applyResume(@NotNull Implementation<PipelineContextRender.Resume, ConsumerService.State> implementation) {
        this.pipelines.resume().apply(implementation);
    }

    public void applyStopUpdate(@NotNull Implementation<PipelineContextRender.StopUpdate, ConsumerService.State> implementation) {
        this.pipelines.stopUpdate().apply(implementation);
    }

    public void applyUpdate(@NotNull Implementation<PipelineContextRender.Update, ConsumerService.State> implementation) {
        this.pipelines.update().apply(implementation);
    }
}

