/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.view.ContextClick;
import net.infumia.frame.context.view.ContextClose;
import net.infumia.frame.context.view.ContextOpen;
import net.infumia.frame.pipeline.context.PipelineContextView;
import net.infumia.frame.slot.LayoutSlot;
import net.infumia.frame.slot.LayoutSlotImpl;
import net.infumia.frame.typedkey.TypedKeyStorageImmutable;
import net.infumia.frame.view.View;
import net.infumia.frame.view.ViewContainer;
import net.infumia.frame.view.config.ViewConfig;
import net.infumia.frame.viewer.Viewer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public interface PipelineContextViews {

    public static final class Close
    implements PipelineContextView.Close {
        private final ContextClose context;
        private boolean cancelled;

        public Close(@NotNull ContextClose context) {
            this.context = context;
        }

        @NotNull
        public ContextClose context() {
            return this.context;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }

    public static final class Click
    implements PipelineContextView.Click {
        private final ContextClick context;
        private boolean cancelled;

        public Click(@NotNull ContextClick context) {
            this.context = context;
        }

        @NotNull
        public ContextClick context() {
            return this.context;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }

    public static final class CreateRender
    implements PipelineContextView.CreateRender {
        private final ContextBase context;
        private final ViewConfig config;
        private final ViewContainer container;
        private final Collection<LayoutSlot> layouts;

        public CreateRender(@NotNull ContextBase context, @NotNull ViewConfig config, @NotNull ViewContainer container, @NotNull Collection<LayoutSlot> layouts) {
            this.context = context;
            this.config = config;
            this.container = container;
            this.layouts = layouts;
        }

        @NotNull
        public ContextBase context() {
            return this.context;
        }

        @NotNull
        public ViewConfig config() {
            return this.config;
        }

        @NotNull
        public ViewContainer container() {
            return this.container;
        }

        @NotNull
        public Collection<LayoutSlot> layouts() {
            return this.layouts;
        }
    }

    public static final class LayoutResolution
    implements PipelineContextView.LayoutResolution {
        private final Collection<LayoutSlot> layouts = new ArrayList<LayoutSlot>();
        private final ContextBase context;
        private final ViewConfig config;
        private final ViewContainer container;

        public LayoutResolution(@NotNull ContextBase context, @NotNull ViewConfig config, @NotNull ViewContainer container) {
            this.context = context;
            this.config = config;
            this.container = container;
        }

        @NotNull
        public ContextBase context() {
            return this.context;
        }

        @NotNull
        public ViewConfig config() {
            return this.config;
        }

        @NotNull
        public ViewContainer container() {
            return this.container;
        }

        @NotNull
        public Collection<LayoutSlot> layouts() {
            return Collections.unmodifiableCollection(this.layouts);
        }

        public void addLayout(char character, @NotNull Collection<Integer> indexes) {
            this.layouts.add(new LayoutSlotImpl(character, indexes.stream().mapToInt(value -> value).toArray()));
        }
    }

    public static final class ModifyContainer
    implements PipelineContextView.ModifyContainer {
        private final ContextBase context;
        private final ViewConfig config;
        private ViewContainer container;

        public ModifyContainer(@NotNull ContextBase context, @NotNull ViewConfig config, @NotNull ViewContainer container) {
            this.context = context;
            this.config = config;
            this.container = container;
        }

        @NotNull
        public ContextBase context() {
            return this.context;
        }

        @NotNull
        public ViewConfig config() {
            return this.config;
        }

        @NotNull
        public ViewContainer container() {
            return this.container;
        }

        public void modifyContainer(@NotNull ViewContainer newContainer) {
            this.container = newContainer;
        }
    }

    public static final class CreateContainer
    implements PipelineContextView.CreateContainer {
        private final ContextBase context;
        private final ViewConfig config;

        public CreateContainer(@NotNull ContextBase context, @NotNull ViewConfig config) {
            this.context = context;
            this.config = config;
        }

        @NotNull
        public ContextBase context() {
            return this.context;
        }

        @NotNull
        public ViewConfig config() {
            return this.config;
        }
    }

    public static final class ProcessConfigModifier
    implements PipelineContextView.ProcessConfigModifier {
        private final ContextOpen context;

        public ProcessConfigModifier(@NotNull ContextOpen context) {
            this.context = context;
        }

        @NotNull
        public ContextOpen context() {
            return this.context;
        }
    }

    public static final class Open
    implements PipelineContextView.Open {
        private final ContextOpen context;
        private boolean cancelled;

        public Open(@NotNull ContextOpen context) {
            this.context = context;
        }

        @NotNull
        public ContextOpen context() {
            return this.context;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }

    public static final class StartTransition
    implements PipelineContextView.StartTransition {
        private final ContextBase context;
        private final Collection<Viewer> viewers;

        public StartTransition(@NotNull ContextBase context, Collection<Viewer> viewers) {
            this.context = context;
            this.viewers = viewers;
        }

        @NotNull
        public ContextBase context() {
            return this.context;
        }

        @NotNull
        public Collection<Viewer> viewers() {
            return this.viewers;
        }
    }

    public static final class CreateContext
    implements PipelineContextView.CreateContext {
        private final View view;
        private final Collection<Viewer> viewers;
        private final TypedKeyStorageImmutable initialData;

        public CreateContext(@NotNull View view, @NotNull Collection<Viewer> viewers, @NotNull TypedKeyStorageImmutable initialData) {
            this.view = view;
            this.viewers = viewers;
            this.initialData = initialData;
        }

        @NotNull
        public View view() {
            return this.view;
        }

        @NotNull
        public Collection<Viewer> viewers() {
            return this.viewers;
        }

        @NotNull
        public TypedKeyStorageImmutable initialData() {
            return this.initialData;
        }
    }

    public static final class CreateViewers
    implements PipelineContextView.CreateViewers {
        private final View view;
        private final Collection<Player> viewers;

        public CreateViewers(@NotNull View view, @NotNull Collection<Player> viewers) {
            this.view = view;
            this.viewers = viewers;
        }

        @NotNull
        public View view() {
            return this.view;
        }

        @NotNull
        public Collection<Player> viewers() {
            return this.viewers;
        }
    }

    public static final class Init
    implements PipelineContextView.Init {
        private final View view;

        public Init(@NotNull View view) {
            this.view = view;
        }

        @NotNull
        public View view() {
            return this.view;
        }
    }
}

