/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline;

import io.leangen.geantyref.TypeToken;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.pipeline.Pipeline;
import net.infumia.frame.pipeline.PipelineService;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.service.ServicePipelineBuilder;
import net.infumia.frame.service.ServiceRepository;
import org.jetbrains.annotations.NotNull;

public class PipelineImpl<Context, Result>
implements Pipeline<Context, Result> {
    private final ServiceRepository<Context, Result> repository;

    private PipelineImpl(@NotNull ServiceRepository<Context, Result> repository) {
        this.repository = repository;
    }

    public PipelineImpl(@NotNull TypeToken<PipelineService<Context, Result>> type, @NotNull PipelineService<Context, Result> defaultService) {
        this(ServicePipelineBuilder.newBuilder().build().create(type, defaultService));
    }

    @NotNull
    public Pipeline<Context, Result> apply(@NotNull Implementation<Context, Result> operation) {
        this.repository.apply(operation);
        return this;
    }

    @NotNull
    public CompletableFuture<Result> completeWith(@NotNull Context context) {
        return this.repository.completeDirect(context);
    }

    @NotNull
    public CompletableFuture<Result> completeWithAsync(@NotNull Context context) {
        return this.repository.completeAsync(context);
    }

    @NotNull
    public Pipeline<Context, Result> cloned() {
        return new PipelineImpl<Context, Result>(this.repository.cloned());
    }
}

