/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.listener;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.infumia.frame.Frame;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.metadata.MetadataAccessFactory;
import net.infumia.frame.metadata.MetadataKeyHolder;
import net.infumia.frame.view.InventoryHolderFrame;
import net.infumia.frame.view.ViewEventHandler;
import net.infumia.frame.viewer.ContextualViewer;
import net.infumia.frame.viewer.Viewer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class InventoryListener
implements Listener {
    private final Plugin plugin;
    private final MetadataAccessFactory metadataAccessFactory;
    private final boolean unregisterOnDisable;
    private final Frame frame;

    public InventoryListener(@NotNull Frame frame, @NotNull Plugin plugin, @NotNull MetadataAccessFactory metadataAccessFactory, boolean unregisterOnDisable) {
        this.frame = frame;
        this.plugin = plugin;
        this.metadataAccessFactory = metadataAccessFactory;
        this.unregisterOnDisable = unregisterOnDisable;
    }

    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (this.unregisterOnDisable && event.getPlugin().getName().equals(this.plugin.getName())) {
            this.frame.unregister();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        this.extractContext(event.getInventory(), (Entity)event.getPlayer(), (viewer, ctx) -> this.frame.loggedFuture(((ViewEventHandler)viewer.view()).simulateClose((ContextRender)ctx, (Viewer)viewer), "Error occurred while viewer '%s' closes an inventory", new Object[]{viewer}));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        this.extractContext(event.getInventory(), (Entity)event.getWhoClicked(), (viewer, ctx) -> this.frame.loggedFuture(((ViewEventHandler)viewer.view()).simulateClick((ContextRender)ctx, (Viewer)viewer, event), "Error occurred while viewer '%s' clicks an inventory!", new Object[]{viewer}));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        this.extractContext(event.getInventory(), (Entity)event.getWhoClicked(), (viewer, ctx) -> ((ViewEventHandler)viewer.view()).handleInventoryDrag((ContextRender)ctx, event));
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemPickup(PlayerPickupItemEvent event) {
        this.extractViewer((Metadatable)event.getPlayer(), viewer -> ((ViewEventHandler)viewer.view()).handleItemPickup(viewer.context(), event));
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent event) {
        this.extractViewer((Metadatable)event.getPlayer(), viewer -> ((ViewEventHandler)viewer.view()).handleItemDrop(viewer.context(), event));
    }

    private void extractViewer(@NotNull Metadatable metadatable, @NotNull Consumer<ContextualViewer> consumer) {
        ContextualViewer viewer = (ContextualViewer)this.metadataAccessFactory.getOrCreate(metadatable).get(MetadataKeyHolder.CONTEXTUAL_VIEWER);
        if (viewer != null) {
            consumer.accept(viewer);
        }
    }

    private void extractContext(@NotNull Inventory inventory, @NotNull Entity involved, @NotNull BiConsumer<Viewer, ContextRender> function) {
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof InventoryHolderFrame)) {
            return;
        }
        ContextRender ctx = ((InventoryHolderFrame)inventoryHolder).context();
        ctx.viewers().stream().filter(viewer -> viewer.player().getUniqueId().equals(involved.getUniqueId())).findFirst().ifPresent(viewer -> function.accept((Viewer)viewer, ctx));
    }
}

