/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.infumia.frame.Frame;
import net.infumia.frame.FrameRich;
import net.infumia.frame.Preconditions;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.extension.CompletableFutureExtensions;
import net.infumia.frame.feature.Feature;
import net.infumia.frame.listener.InventoryListener;
import net.infumia.frame.logger.Logger;
import net.infumia.frame.metadata.MetadataAccessFactory;
import net.infumia.frame.metadata.MetadataAccessFactoryImpl;
import net.infumia.frame.pipeline.executor.PipelinesFrame;
import net.infumia.frame.pipeline.executor.PipelinesFrameImpl;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.task.TaskFactory;
import net.infumia.frame.task.TaskFactoryImpl;
import net.infumia.frame.typedkey.TypedKeyStorageFactory;
import net.infumia.frame.typedkey.TypedKeyStorageImmutableBuilder;
import net.infumia.frame.view.View;
import net.infumia.frame.view.ViewEventHandler;
import net.infumia.frame.view.ViewFactory;
import net.infumia.frame.view.ViewFactoryImpl;
import net.infumia.frame.view.creator.InventoryFactory;
import net.infumia.frame.view.creator.InventoryFactoryBukkit;
import net.infumia.frame.viewer.ViewerFactory;
import net.infumia.frame.viewer.ViewerFactoryImpl;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FrameImpl
implements FrameRich {
    private final Collection<Class<?>> unregisteredViews = ConcurrentHashMap.newKeySet();
    private final Map<Class<?>, View> registeredViews = new ConcurrentHashMap();
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final PipelinesFrame pipelines = new PipelinesFrameImpl(this);
    private final ViewFactory viewFactory = new ViewFactoryImpl();
    private final Logger logger;
    private final TaskFactory taskFactory;
    private final InventoryListener listener;
    private final MetadataAccessFactory metadataAccessFactory;
    private final ViewerFactory viewerFactory;
    private TypedKeyStorageFactory storageFactory = TypedKeyStorageFactory.create();
    private InventoryFactory inventoryFactory = InventoryFactoryBukkit.bukkitOrPaper();

    FrameImpl(@NotNull Plugin plugin, @NotNull Logger logger, boolean unregisterOnDisable) {
        this.logger = logger;
        this.taskFactory = new TaskFactoryImpl(plugin);
        this.metadataAccessFactory = new MetadataAccessFactoryImpl(plugin);
        this.viewerFactory = new ViewerFactoryImpl(this.metadataAccessFactory);
        this.listener = new InventoryListener(this, plugin, this.metadataAccessFactory, unregisterOnDisable);
    }

    @Override
    @NotNull
    public InventoryListener listener() {
        return this.listener;
    }

    public void register() {
        this.register(__ -> {});
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> register(@NotNull Consumer<TypedKeyStorageImmutableBuilder> instanceConfigurer) {
        Preconditions.state((!this.registered.get() ? 1 : 0) != 0, (String)"This frame is already registered! #register() method cannot be called twice!", (Object[])new Object[0]);
        this.registered.set(true);
        return ((CompletableFuture)((CompletableFuture)this.pipelines.executeViewCreated(this.unregisteredViews).thenCompose(instances -> this.pipelines.executeViewRegistered(instances, instanceConfigurer))).thenCompose(views -> {
            this.registeredViews.clear();
            this.registeredViews.putAll(views.stream().collect(Collectors.toMap(view -> view.instance().getClass(), Function.identity())));
            return this.pipelines.executeListenersRegistered();
        })).exceptionally(throwable -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (throwable != null) {
                this.unregister();
                this.logger.error(throwable, "Error occurred while registering views!", new Object[0]);
            }
            return null;
        });
    }

    public void unregister() {
        this.registered.set(false);
        this.metadataAccessFactory.clearCache(Bukkit.getOnlinePlayers());
        HandlerList.unregisterAll((Listener)this.listener);
        HashMap views = new HashMap(this.registeredViews);
        this.registeredViews.clear();
        this.loggedFuture(this.pipelines.executeViewUnregistered(views.values()), "Error occurred while unregistering views '%s'!", views.keySet());
    }

    @NotNull
    public Frame with(@NotNull Class<?> viewClass) {
        Preconditions.argument((!this.registered.get() ? 1 : 0) != 0, (String)"This frame is registered!", (Object[])new Object[0]);
        Preconditions.argument((!this.unregisteredViews.contains(viewClass) ? 1 : 0) != 0, (String)"View class '%s' already registered.", (Object[])new Object[]{viewClass});
        this.logger.debug("View class '%s' recognized.", new Object[]{viewClass});
        this.unregisteredViews.add(viewClass);
        return this;
    }

    @NotNull
    public Logger logger() {
        return this.logger;
    }

    @NotNull
    public TaskFactory taskFactory() {
        return this.taskFactory;
    }

    @NotNull
    public ViewFactory viewFactory() {
        return this.viewFactory;
    }

    @NotNull
    public ViewerFactory viewerFactory() {
        return this.viewerFactory;
    }

    @NotNull
    public TypedKeyStorageFactory storageFactory() {
        return this.storageFactory;
    }

    public void storageFactory(@NotNull TypedKeyStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    @NotNull
    public InventoryFactory inventoryFactory() {
        return this.inventoryFactory;
    }

    public void inventoryFactory(@NotNull InventoryFactory inventoryFactory) {
        this.inventoryFactory = inventoryFactory;
    }

    @NotNull
    public <T> CompletableFuture<T> loggedFuture(@NotNull CompletableFuture<T> future, @NotNull String message, Object ... args) {
        return CompletableFutureExtensions.logError(future, this.logger, message, args);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> open(@NotNull Player player, @NotNull Class<?> viewClass) {
        return this.open(Collections.singleton(player), viewClass);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> open(@NotNull Player player, @NotNull Class<?> viewClass, @NotNull Consumer<TypedKeyStorageImmutableBuilder> initialDataConfigurer) {
        return this.open(Collections.singleton(player), viewClass, initialDataConfigurer);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> open(@NotNull Collection<Player> players, @NotNull Class<?> viewClass) {
        return this.open(players, viewClass, (TypedKeyStorageImmutableBuilder builder) -> {});
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> open(@NotNull Collection<Player> players, @NotNull Class<?> viewClass, @NotNull Consumer<TypedKeyStorageImmutableBuilder> initialDataConfigurer) {
        Preconditions.state((boolean)this.registered.get(), (String)"Before you open a view you must register this frame!", (Object[])new Object[0]);
        View view = (View)Preconditions.argumentNotNull((Object)this.registeredViews.get(viewClass), (String)"View '%s' is not registered!", (Object[])new Object[]{viewClass});
        if (!(view instanceof ViewEventHandler)) {
            return CompletableFuture.completedFuture(null);
        }
        TypedKeyStorageImmutableBuilder builder = this.storageFactory.createImmutableBuilder(new HashMap());
        initialDataConfigurer.accept(builder);
        return this.loggedFuture(this.taskFactory.handleFuture(() -> ((ViewEventHandler)view).simulateOpen(players, builder.build())), "Error occurred while opening view '%s'!", viewClass);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> openActive(@NotNull Player player, @NotNull ContextRender activeContext) {
        return this.openActive(Collections.singleton(player), activeContext);
    }

    public @NotNull CompletableFuture<@Nullable ContextRender> openActive(@NotNull Collection<Player> players, @NotNull ContextRender activeContext) {
        View view = activeContext.view();
        Preconditions.argument((boolean)(view instanceof ViewEventHandler), (String)"The active context's view must be an instance of ViewEventHandler!", (Object[])new Object[0]);
        return this.loggedFuture(this.taskFactory.handleFuture(() -> ((ViewEventHandler)view).simulateOpenActive(activeContext, players)), "Error occurred while opening an active view '%s'!", view.instance());
    }

    @NotNull
    public PipelinesFrame pipelines() {
        return this.pipelines;
    }

    @NotNull
    public Frame installFeature(@NotNull Class<? extends Feature> feature) {
        return this;
    }

    @NotNull
    public Frame installFeature(@NotNull Feature feature) {
        return this;
    }
}

